/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.item.tile.ItemLockable;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileLockable;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedChest;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReinforcedChest
extends TileLockable {
    public TileReinforcedChest(Material material) {
        super(material);
        this.setHardness(8.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeWood);
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.setHarvestLevel("axe", 2);
    }

    public TileReinforcedChest() {
        this(Material.wood);
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemLockable.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("log_oak");
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return ClientProxy.reinforcedChestRenderId;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntityReinforcedChest chest = WorldUtils.get(world, x, y, z, TileEntityReinforcedChest.class);
        if (chest.isConnected()) {
            ForgeDirection connected = chest.getConnected();
            if (connected == ForgeDirection.NORTH) {
                this.setBlockBounds(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
            } else if (connected == ForgeDirection.SOUTH) {
                this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
            } else if (connected == ForgeDirection.WEST) {
                this.setBlockBounds(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
            } else if (connected == ForgeDirection.EAST) {
                this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
            }
        } else {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        }
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityReinforcedChest();
    }
}

