/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.item.tile.ItemLockable;
import net.mcft.copy.betterstorage.proxy.ClientProxy;
import net.mcft.copy.betterstorage.tile.TileLockable;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLocker;
import net.mcft.copy.betterstorage.tile.entity.TileEntityReinforcedLocker;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReinforcedLocker
extends TileLockable {
    public TileReinforcedLocker(Material material) {
        super(material);
        this.setHardness(8.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeWood);
        this.setBlockBounds(0.0625f, 0.0625f, 0.0625f, 0.9375f, 0.9375f, 0.9375f);
        this.setHarvestLevel("axe", 2);
    }

    public TileReinforcedLocker() {
        this(Material.wood);
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemLockable.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("log_oak");
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return ClientProxy.reinforcedLockerRenderId;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntityLocker locker = WorldUtils.get(world, x, y, z, TileEntityLocker.class);
        return locker == null || locker.getOrientation() != side;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        switch (WorldUtils.get(world, x, y, z, TileEntityLocker.class).getOrientation()) {
            case EAST: {
                maxX -= 0.0625f;
                break;
            }
            case WEST: {
                minX += 0.0625f;
                break;
            }
            case SOUTH: {
                maxZ -= 0.0625f;
                break;
            }
            case NORTH: {
                minZ += 0.0625f;
                break;
            }
        }
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityReinforcedLocker();
    }
}

