/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.mcft.copy.betterstorage.misc.ItemIdentifier;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.item.ItemStack;

public class CrateItems {
    private final Map<ItemIdentifier, ItemStack> itemsMap = new HashMap<ItemIdentifier, ItemStack>();
    private int totalStacks = 0;
    private NavigableMap<Integer, ItemStack> weightedMap = new TreeMap<Integer, ItemStack>();
    private boolean weightedMapDirty = false;

    public int getUniqueItems() {
        return this.itemsMap.size();
    }

    public int getTotalStacks() {
        return this.totalStacks;
    }

    public int get(ItemIdentifier item) {
        ItemStack stack = this.itemsMap.get(item);
        return stack != null ? stack.stackSize : 0;
    }

    public void set(ItemIdentifier item, int amount) {
        int stacksAfter;
        int stacksBefore;
        ItemStack stack = this.itemsMap.get(item);
        if (stack != null) {
            if (amount == stack.stackSize) {
                return;
            }
            stacksBefore = StackUtils.calcNumStacks(stack);
            if (amount > 0) {
                stack.stackSize = amount;
                stacksAfter = StackUtils.calcNumStacks(stack);
            } else {
                stacksAfter = 0;
                this.itemsMap.remove(item);
            }
        } else if (amount > 0) {
            stack = item.createStack(amount);
            stacksBefore = 0;
            stacksAfter = StackUtils.calcNumStacks(stack);
            this.itemsMap.put(item, stack);
        } else {
            return;
        }
        if (stacksBefore != stacksAfter) {
            this.totalStacks += stacksAfter - stacksBefore;
            this.weightedMapDirty = true;
        }
    }

    public Iterable<ItemStack> getItems() {
        return this.itemsMap.values();
    }

    public Iterable<ItemStack> getRandomStacks() {
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return new ItemsIterator(CrateItems.this.getWeightedMap(), CrateItems.this.getTotalStacks());
            }
        };
    }

    public List<ItemStack> getRandomStacks(int amount) {
        amount = Math.min(amount, this.getTotalStacks());
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(amount);
        for (ItemStack stack : this.getRandomStacks()) {
            stacks.add(stack);
            if (stacks.size() < amount) continue;
            break;
        }
        return stacks;
    }

    private NavigableMap<Integer, ItemStack> getWeightedMap() {
        if (this.weightedMapDirty) {
            this.weightedMap.clear();
            int stacks = 0;
            for (ItemStack stack : this.getItems()) {
                this.weightedMap.put(stacks += StackUtils.calcNumStacks(stack), stack);
            }
        }
        return this.weightedMap;
    }

    private static class ItemsIterator
    implements Iterator<ItemStack> {
        private final NavigableMap<Integer, ItemStack> map;
        private final int stacks;
        private final TreeSet<Integer> picked = new TreeSet();

        public ItemsIterator(NavigableMap<Integer, ItemStack> map, int stacks) {
            this.map = map;
            this.stacks = stacks;
        }

        @Override
        public boolean hasNext() {
            return this.picked.size() < this.stacks;
        }

        @Override
        public ItemStack next() {
            int index;
            if (!this.picked.isEmpty()) {
                int p;
                Iterator<Integer> iterator = this.picked.iterator();
                for (index = 1 + RandomUtils.getInt(this.stacks - this.picked.size()); iterator.hasNext() && (p = iterator.next().intValue()) <= index; ++index) {
                }
            }
            this.picked.add(index);
            Map.Entry<Integer, ItemStack> entry = this.map.ceilingEntry(index);
            ItemStack stack = entry.getValue();
            int maxStackSize = stack.getMaxStackSize();
            int amount = index != entry.getKey() ? maxStackSize : (stack.stackSize - 1) % maxStackSize + 1;
            return StackUtils.copyStack(stack, amount);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

