/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.utils.NbtUtils;
import net.mcft.copy.betterstorage.utils.PlayerUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;

public abstract class TileEntityContainer
extends TileEntity {
    public final ItemStack[] contents;
    private final InventoryTileEntity playerInventory;
    private String customTitle = null;
    private int playersUsing = 0;
    protected boolean brokenInCreative = false;
    public int ticksExisted = 0;
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    private int redstonePower = 0;
    private boolean compAccessedOnLoad = false;
    private boolean compAccessed = false;
    private boolean compContentsChanged = false;

    public int getColumns() {
        return 9;
    }

    public int getRows() {
        return 3;
    }

    protected int getSizeContents() {
        return this.getColumns() * this.getRows();
    }

    public abstract String getName();

    public final int getPlayersUsing() {
        return this.playersUsing;
    }

    public TileEntityContainer() {
        int size = this.getSizeContents();
        this.contents = size > 0 ? new ItemStack[size] : null;
        this.playerInventory = this.makePlayerInventory();
    }

    public InventoryTileEntity makePlayerInventory() {
        return this.contents != null ? new InventoryTileEntity(this) : null;
    }

    public InventoryTileEntity getPlayerInventory() {
        return this.playerInventory;
    }

    public boolean canPlayerUseContainer(EntityPlayer player) {
        return WorldUtils.isTileEntityUsableByPlayer(this, player);
    }

    public ContainerBetterStorage createContainer(EntityPlayer player) {
        return new ContainerBetterStorage(player, this.getPlayerInventory());
    }

    public String getContainerTitle() {
        return this.hasCustomTitle() ? this.getCustomTitle() : this.getName();
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public boolean hasCustomTitle() {
        return this.getCustomTitle() != null;
    }

    public boolean shouldLocalizeTitle() {
        return !this.hasCustomTitle();
    }

    public boolean canSetCustomTitle() {
        return true;
    }

    public void setCustomTitle(String title) {
        if (this.canSetCustomTitle()) {
            this.customTitle = title;
        }
    }

    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        if (stack.hasDisplayName()) {
            this.setCustomTitle(stack.getDisplayName());
        }
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.worldObj.isRemote) {
            return true;
        }
        if (!this.canPlayerUseContainer(player)) {
            return true;
        }
        this.openGui(player);
        return true;
    }

    public void openGui(EntityPlayer player) {
        ContainerBetterStorage container = this.createContainer(player);
        PlayerUtils.openGui(player, this.getName(), container.getColumns(), container.getRows(), this.getCustomTitle(), container);
    }

    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        return block;
    }

    public boolean onBlockBreak(EntityPlayer player) {
        this.brokenInCreative = player.capabilities.isCreativeMode;
        return true;
    }

    public void onNeighborUpdate(Block neighborBlock) {
        if (this.acceptsRedstoneSignal() && neighborBlock.canProvidePower()) {
            this.checkForRedstoneChange();
        }
    }

    public void onBlockDestroyed() {
        this.dropContents();
        this.brokenInCreative = false;
    }

    public void dropContents() {
        if (this.contents != null) {
            for (ItemStack stack : this.contents) {
                WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
    }

    protected boolean acceptsRedstoneSignal() {
        return false;
    }

    protected boolean requiresStrongSignal() {
        return false;
    }

    public int getRedstonePower() {
        return this.redstonePower;
    }

    public boolean isRedstonePowered() {
        return this.getRedstonePower() > 0;
    }

    protected void checkForRedstoneChange() {
        int previousPower = this.redstonePower;
        int n = this.redstonePower = this.requiresStrongSignal() ? this.getStrongRedstoneSignal() : this.getWeakRedstoneSignal();
        if (this.redstonePower == previousPower) {
            return;
        }
        this.onRedstonePowerChanged(previousPower, this.redstonePower);
        if (previousPower <= 0) {
            this.onRedstoneActivated();
        }
        if (this.redstonePower <= 0) {
            this.onRedstoneDeactivated();
        }
    }

    protected void onRedstonePowerChanged(int previousPower, int currentPower) {
    }

    protected void onRedstoneActivated() {
    }

    protected void onRedstoneDeactivated() {
    }

    protected int getStrongRedstoneSignal() {
        return this.worldObj.getBlockPowerInput(this.xCoord, this.yCoord, this.zCoord);
    }

    protected int getWeakRedstoneSignal() {
        return this.worldObj.getStrongestIndirectPower(this.xCoord, this.yCoord, this.zCoord);
    }

    protected boolean hasComparatorAccessed() {
        return this.compAccessed;
    }

    protected boolean hasContentsChanged() {
        return this.compContentsChanged;
    }

    public static int getContainerComparatorSignalStrength(IBlockAccess world, int x, int y, int z) {
        TileEntityContainer container = WorldUtils.get(world, x, y, z, TileEntityContainer.class);
        return container != null ? container.getComparatorSignalStrength() : 0;
    }

    public int getComparatorSignalStrength() {
        this.markComparatorAccessed();
        return this.getComparatorSignalStengthInternal();
    }

    protected void markComparatorAccessed() {
        this.compAccessed = true;
    }

    protected void markContentsChanged() {
        this.compContentsChanged = true;
    }

    protected int getComparatorSignalStengthInternal() {
        return this instanceof IInventory ? Container.calcRedstoneFromInventory((IInventory)((IInventory)this)) : 0;
    }

    protected void comparatorUpdateAndReset() {
        this.compAccessed = false;
        this.compContentsChanged = false;
        WorldUtils.notifyBlocksAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    public void markDirtySuper() {
        if (this.worldObj.isRemote) {
            return;
        }
        this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
        if (this.hasComparatorAccessed()) {
            this.markContentsChanged();
        }
    }

    public void markDirty() {
        this.markDirtySuper();
    }

    public void validate() {
        if (this.compAccessedOnLoad) {
            this.markComparatorAccessed();
            this.compAccessedOnLoad = false;
        }
    }

    protected boolean doesSyncPlayers() {
        return false;
    }

    protected boolean syncPlayersUsing() {
        return !this.worldObj.isRemote && this.doesSyncPlayers() && (this.ticksExisted + this.xCoord + this.yCoord + this.zCoord & 0xFF) == 0 && this.worldObj.doChunksNearChunkExist(this.xCoord, this.yCoord, this.zCoord, 16);
    }

    private void doSyncPlayersUsing(int playersUsing) {
        if (!this.doesSyncPlayers()) {
            return;
        }
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, playersUsing);
    }

    public boolean receiveClientEvent(int event, int value) {
        if (event == 0) {
            this.playersUsing = value;
        }
        return true;
    }

    public void onContainerOpened() {
        this.doSyncPlayersUsing(++this.playersUsing);
    }

    public void onContainerClosed() {
        this.doSyncPlayersUsing(--this.playersUsing);
    }

    protected float getLidSpeed() {
        return 0.1f;
    }

    public void updateEntity() {
        int newPlayersUsing;
        if (this.ticksExisted++ == 0) {
            this.checkForRedstoneChange();
        }
        if (this.hasComparatorAccessed() && this.hasContentsChanged()) {
            this.comparatorUpdateAndReset();
        }
        if (this.syncPlayersUsing() && (newPlayersUsing = WorldUtils.syncPlayersUsing(this, this.playersUsing)) != this.playersUsing) {
            this.playersUsing = newPlayersUsing;
            this.doSyncPlayersUsing(this.playersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        if (this.playersUsing > 0) {
            if (this.lidAngle < 1.0f) {
                this.lidAngle = Math.min(1.0f, this.lidAngle + this.getLidSpeed());
            }
        } else if (this.lidAngle > 0.0f) {
            this.lidAngle = Math.max(0.0f, this.lidAngle - this.getLidSpeed());
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound.hasKey("CustomName")) {
            this.customTitle = compound.getString("CustomName");
        }
        if (this.contents != null) {
            NbtUtils.readItems(this.contents, compound.getTagList("Items", 10));
        }
        if (compound.getBoolean("ComparatorAccessed")) {
            this.compAccessedOnLoad = true;
        }
        if (this.acceptsRedstoneSignal()) {
            this.redstonePower = compound.getByte("RedstonePower");
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.customTitle != null) {
            compound.setString("CustomName", this.customTitle);
        }
        if (this.contents != null) {
            compound.setTag("Items", (NBTBase)NbtUtils.writeItems(this.contents));
        }
        if (this.hasComparatorAccessed()) {
            compound.setBoolean("ComparatorAccessed", true);
        }
        if (this.acceptsRedstoneSignal()) {
            compound.setByte("RedstonePower", (byte)this.redstonePower);
        }
    }

    public void markForUpdate() {
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
    }
}

