/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.api.lock.EnumLockInteraction;
import net.mcft.copy.betterstorage.api.lock.ILock;
import net.mcft.copy.betterstorage.api.lock.ILockable;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.attachment.LockAttachment;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLockableDoor
extends TileEntity
implements ILockable,
IHasAttachments {
    private Attachments attachments = new Attachments(this);
    public LockAttachment lockAttachment;
    public ForgeDirection orientation = ForgeDirection.NORTH;
    private boolean powered = false;
    private boolean swing = false;
    public boolean isOpen = false;
    public boolean isMirrored = false;

    public TileEntityLockableDoor() {
        this.lockAttachment = this.attachments.add(LockAttachment.class);
        this.lockAttachment.setScale(0.5f, 1.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    private void updateLockPosition() {
        switch (this.orientation) {
            case WEST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(12.5, -1.5, 1.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(1.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                break;
            }
            case EAST: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(3.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                    break;
                }
                this.lockAttachment.setBox(14.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                break;
            }
            case SOUTH: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(1.5, -1.5, 3.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(12.5, -1.5, 14.5, 5.0, 6.0, 3.0);
                break;
            }
            default: {
                if (this.isOpen) {
                    this.lockAttachment.setBox(14.5, -1.5, 12.5, 3.0, 6.0, 5.0);
                    break;
                }
                this.lockAttachment.setBox(3.5, -1.5, 1.5, 5.0, 6.0, 3.0);
            }
        }
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public ItemStack getLock() {
        return this.lockAttachment.getItem();
    }

    @Override
    public boolean isLockValid(ItemStack lock) {
        return lock == null || lock.getItem() instanceof ILock;
    }

    @Override
    public void setLock(ItemStack lock) {
        if (lock == null) {
            int rotation;
            this.lockAttachment.setItem(null);
            int n = this.orientation == ForgeDirection.WEST ? 0 : (this.orientation == ForgeDirection.NORTH ? 1 : (rotation = this.orientation == ForgeDirection.EAST ? 2 : 3));
            rotation = this.isMirrored ? (rotation == 0 ? 1 : (rotation == 1 ? 2 : (rotation == 2 ? 3 : 0))) : rotation;
            this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, Blocks.iron_door, rotation, 2);
            this.worldObj.setBlock(this.xCoord, this.yCoord + 1, this.zCoord, Blocks.iron_door, this.isMirrored ? 9 : 8, 2);
            this.worldObj.notifyBlockChange(this.xCoord, this.yCoord, this.zCoord, Blocks.iron_door);
            this.worldObj.notifyBlockChange(this.xCoord, this.yCoord + 1, this.zCoord, Blocks.iron_door);
        } else {
            this.setLockWithUpdate(lock);
        }
    }

    public void setLockWithUpdate(ItemStack lock) {
        this.lockAttachment.setItem(lock);
        this.updateLockPosition();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
    }

    @Override
    public boolean canUse(EntityPlayer player) {
        return false;
    }

    @Override
    public void useUnlocked(EntityPlayer player) {
        this.isOpen = !this.isOpen;
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, this.isOpen ? 1 : 0);
        this.updateLockPosition();
    }

    @Override
    public void applyTrigger() {
        this.setPowered(true);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (this.canUse(player)) {
            this.useUnlocked(player);
        } else {
            ((ILock)this.getLock().getItem()).applyEffects(this.getLock(), this, player, EnumLockInteraction.OPEN);
        }
        return true;
    }

    public boolean receiveClientEvent(int eventID, int par) {
        this.worldObj.playAuxSFX(1003, this.xCoord, this.yCoord, this.zCoord, 0);
        this.swing = true;
        this.isOpen = par == 1;
        this.updateLockPosition();
        this.worldObj.markBlockRangeForRenderUpdate(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public void updateEntity() {
        this.attachments.update();
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.isOpen = compound.getBoolean("isOpen");
        this.isMirrored = compound.getBoolean("isMirrored");
        this.orientation = ForgeDirection.getOrientation((int)compound.getByte("orientation"));
        if (compound.hasKey("lock")) {
            this.lockAttachment.setItem(ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lock")));
        }
        this.updateLockPosition();
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setBoolean("isOpen", this.isOpen);
        compound.setBoolean("isMirrored", this.isMirrored);
        compound.setByte("orientation", (byte)this.orientation.ordinal());
        if (this.lockAttachment.getItem() != null) {
            compound.setTag("lock", (NBTBase)this.lockAttachment.getItem().writeToNBT(new NBTTagCompound()));
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.setBoolean("isOpen", this.isOpen);
        compound.setBoolean("isMirrored", this.isMirrored);
        compound.setByte("orientation", (byte)this.orientation.ordinal());
        if (this.lockAttachment.getItem() != null) {
            compound.setTag("lock", (NBTBase)this.lockAttachment.getItem().writeToNBT(new NBTTagCompound()));
        }
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound compound = pkt.func_148857_g();
        if (!compound.hasKey("lock")) {
            this.lockAttachment.setItem(null);
        } else {
            this.lockAttachment.setItem(ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("lock")));
        }
        this.orientation = ForgeDirection.getOrientation((int)compound.getByte("orientation"));
        this.isOpen = compound.getBoolean("isOpen");
        this.isMirrored = compound.getBoolean("isMirrored");
        this.updateLockPosition();
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean powered) {
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        if (powered) {
            this.worldObj.scheduleBlockUpdate(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 10);
        }
        WorldUtils.notifyBlocksAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        WorldUtils.notifyBlocksAround(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord);
    }
}

