/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable;
import net.mcft.copy.betterstorage.tile.entity.TileEntityLockable;
import net.mcft.copy.betterstorage.utils.DirectionUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLocker
extends TileEntityLockable {
    private static final ForgeDirection[] neighbors = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP};
    public boolean mirror = false;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getResource() {
        return this.isConnected() ? Resources.textureLockerLarge : Resources.textureLocker;
    }

    @Override
    public boolean canHaveLock() {
        return false;
    }

    @Override
    public boolean canHaveMaterial() {
        return false;
    }

    @Override
    public void setAttachmentPosition() {
    }

    @Override
    public ForgeDirection[] getPossibleNeighbors() {
        return neighbors;
    }

    @Override
    protected String getConnectableName() {
        return "container.betterstorage.locker";
    }

    @Override
    public boolean canConnect(TileEntityConnectable connectable) {
        if (!(connectable instanceof TileEntityLocker)) {
            return false;
        }
        TileEntityLocker locker = (TileEntityLocker)connectable;
        return super.canConnect(connectable) && this.mirror == locker.mirror;
    }

    @Override
    public void onBlockPlacedBeforeCheckingConnections(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBeforeCheckingConnections(player, stack);
        double angle = DirectionUtils.getRotation(this.getOrientation().getOpposite());
        double yaw = (player.rotationYaw % 360.0f + 360.0f) % 360.0f;
        this.mirror = DirectionUtils.angleDifference(angle, yaw) > 0.0;
        this.setAttachmentPosition();
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.getOrientation().ordinal() != side) {
            return true;
        }
        return super.onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound getDescriptionPacketData(NBTTagCompound compound) {
        compound = super.getDescriptionPacketData(compound);
        compound.setBoolean("mirror", this.mirror);
        return compound;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        this.mirror = compound.getBoolean("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.mirror = compound.getBoolean("mirror");
        this.setAttachmentPosition();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setBoolean("mirror", this.mirror);
    }
}

