/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.content.BetterStorageTiles;
import net.mcft.copy.betterstorage.item.tile.ItemCardboardBox;
import net.mcft.copy.betterstorage.network.packet.PacketPresentOpen;
import net.mcft.copy.betterstorage.tile.entity.TileEntityCardboardBox;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;

public class TileEntityPresent
extends TileEntityCardboardBox {
    public static final String TAG_COLOR_INNER = "presentColorInner";
    public static final String TAG_COLOR_OUTER = "presentColorOuter";
    public static final String TAG_SKOJANZA_MODE = "skojanzaMode";
    public static final String TAG_NAMETAG = "nameTag";
    public int colorInner = 14;
    public int colorOuter = 0;
    public boolean skojanzaMode = false;
    public String nameTag = null;
    public int breakProgress = 0;
    public int breakPause = 0;

    @Override
    protected boolean canPickUp() {
        return true;
    }

    @Override
    protected ItemStack getItemDropped() {
        return !this.destroyed ? new ItemStack((Block)BetterStorageTiles.present) : null;
    }

    @Override
    protected void onItemDropped(ItemStack stack) {
        super.onItemDropped(stack);
        NBTTagCompound compound = stack.getTagCompound();
        compound.setByte(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.setByte(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.setBoolean(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.setString(TAG_NAMETAG, this.nameTag);
        }
        StackUtils.remove(stack, "display", "color");
        compound.setInteger("color", this.color);
    }

    @Override
    public void updateEntity() {
        this.breakPause = Math.max(0, this.breakPause - 1);
        if (this.breakPause <= 0) {
            this.breakProgress = Math.max(0, this.breakProgress - 1);
        }
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.colorInner = StackUtils.get(stack, (byte)14, TAG_COLOR_INNER).byteValue();
        this.colorOuter = StackUtils.get(stack, (byte)0, TAG_COLOR_OUTER).byteValue();
        this.skojanzaMode = StackUtils.get(stack, (byte)0, TAG_SKOJANZA_MODE) > 0;
        this.nameTag = StackUtils.get(stack, null, TAG_NAMETAG);
        this.color = StackUtils.get(stack, -1, "color");
        this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.colorInner, 2);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack holding = player.getCurrentEquippedItem();
        if (holding == null) {
            if (this.breakPause > 0) {
                return false;
            }
            this.breakPause = 10 - this.breakProgress / 10;
            if (this.nameTag != null && !player.getCommandSenderName().equalsIgnoreCase(this.nameTag)) {
                this.breakPause = 40;
                if (!this.worldObj.isRemote) {
                    ((EntityPlayerMP)player).addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "This present is for " + this.nameTag + ", not you!"));
                }
                return false;
            }
            if ((this.breakProgress += 20) > 100) {
                this.destroyed = true;
            }
            if (this.worldObj.isRemote) {
                return true;
            }
            double x = (double)this.xCoord + 0.5;
            double y = (double)this.yCoord + 0.5;
            double z = (double)this.zCoord + 0.5;
            String sound = Block.soundTypeCloth.getBreakSound();
            this.worldObj.playSoundEffect(x, y, z, sound, 0.75f, 0.8f + (float)this.breakProgress / 80.0f);
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, sound, 1.0f, 0.4f + (float)this.breakProgress / 160.0f);
            BetterStorage.networkChannel.sendToAllAround(new PacketPresentOpen(this.xCoord, this.yCoord, this.zCoord, this.destroyed), this.worldObj, x, y, z, 64.0);
            if (!this.destroyed) {
                return true;
            }
            if (BetterStorageTiles.cardboardBox != null) {
                if (this.worldObj.setBlock(this.xCoord, this.yCoord, this.zCoord, (Block)BetterStorageTiles.cardboardBox)) {
                    TileEntityCardboardBox box = WorldUtils.get((IBlockAccess)this.worldObj, this.xCoord, this.yCoord, this.zCoord, TileEntityCardboardBox.class);
                    box.uses = ItemCardboardBox.getUses();
                    box.color = this.color;
                    System.arraycopy(this.contents, 0, box.contents, 0, this.contents.length);
                } else {
                    for (ItemStack stack : this.contents) {
                        WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
                    }
                }
            } else if (this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord)) {
                for (ItemStack stack : this.contents) {
                    WorldUtils.dropStackFromBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, stack);
                }
            }
            return true;
        }
        if (holding.getItem() == Items.name_tag && this.nameTag == null && holding.hasDisplayName()) {
            if (holding.getDisplayName().matches("^[a-zA-Z0-9_]{2,16}$")) {
                if (!this.worldObj.isRemote) {
                    this.nameTag = holding.getDisplayName();
                    --holding.stackSize;
                    this.markForUpdate();
                }
                return true;
            }
            if (!this.worldObj.isRemote) {
                ((EntityPlayerMP)player).addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + "The nametag doesn't seem to contain a valid username."));
            }
            return false;
        }
        return false;
    }

    @Override
    public void dropContents() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onBlockRenderAsItem(ItemStack stack) {
        NBTTagCompound compound = stack.getTagCompound();
        this.colorInner = StackUtils.get(stack, (byte)14, TAG_COLOR_INNER).byteValue();
        this.colorOuter = StackUtils.get(stack, (byte)0, TAG_COLOR_OUTER).byteValue();
        this.skojanzaMode = StackUtils.get(stack, (byte)0, TAG_SKOJANZA_MODE) > 0;
        this.nameTag = StackUtils.get(stack, null, TAG_NAMETAG);
    }

    @Override
    public Packet getDescriptionPacket() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.color >= 0) {
            compound.setInteger("color", this.color);
        }
        compound.setByte(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.setByte(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.setBoolean(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.setString(TAG_NAMETAG, this.nameTag);
        }
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 0, compound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        NBTTagCompound compound = packet.func_148857_g();
        this.colorInner = compound.getByte(TAG_COLOR_INNER);
        this.colorOuter = compound.getByte(TAG_COLOR_OUTER);
        this.skojanzaMode = compound.getBoolean(TAG_SKOJANZA_MODE);
        this.nameTag = compound.hasKey(TAG_NAMETAG) ? compound.getString(TAG_NAMETAG) : null;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.colorInner = compound.getByte(TAG_COLOR_INNER);
        this.colorOuter = compound.getByte(TAG_COLOR_OUTER);
        this.skojanzaMode = compound.getBoolean(TAG_SKOJANZA_MODE);
        this.nameTag = compound.hasKey(TAG_NAMETAG) ? compound.getString(TAG_NAMETAG) : null;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setByte(TAG_COLOR_INNER, (byte)this.colorInner);
        compound.setByte(TAG_COLOR_OUTER, (byte)this.colorOuter);
        compound.setBoolean(TAG_SKOJANZA_MODE, this.skojanzaMode);
        if (this.nameTag != null) {
            compound.setString(TAG_NAMETAG, this.nameTag);
        }
    }
}

