/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public final class DirectionUtils {
    private DirectionUtils() {
    }

    public static ForgeDirection getOrientation(Entity entity) {
        int dir = MathHelper.floor_double((double)((double)entity.rotationYaw * 4.0 / 360.0 + 0.5)) & 3;
        switch (dir) {
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static int getRotation(ForgeDirection dir) {
        if (dir == ForgeDirection.WEST) {
            return 90;
        }
        if (dir == ForgeDirection.NORTH) {
            return 180;
        }
        if (dir == ForgeDirection.EAST) {
            return 270;
        }
        return 0;
    }

    public static double angleDifference(double angle1, double angle2) {
        return ((angle2 - angle1) % 360.0 + 540.0) % 360.0 - 180.0;
    }

    public static double angleBetween(double x1, double y1, double x2, double y2) {
        return Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
    }

    public static double angleBetween(Entity e1, Entity e2) {
        return DirectionUtils.angleBetween(e1.posX, e1.posZ, e2.posX, e2.posZ);
    }
}

