/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.betterstorage.utils.DyeUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class InventoryUtils {
    private InventoryUtils() {
    }

    public static boolean hasItem(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static ItemStack findItem(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            return stack;
        }
        return null;
    }

    public static int findItemSlot(IInventory inventory, Item item) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            return i;
        }
        return -1;
    }

    public static int countItems(IInventory inventory, Item item) {
        int count = 0;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            ++count;
        }
        return count;
    }

    public static List<ItemStack> findItems(IInventory inventory, Item item) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            list.add(stack);
        }
        return list;
    }

    public static List<Integer> findItemSlots(IInventory inventory, Item item) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() != item) continue;
            list.add(i);
        }
        return list;
    }

    public static List<ItemStack> findDyes(IInventory inventory) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!DyeUtils.isDye(stack)) continue;
            list.add(stack);
        }
        return list;
    }

    public static boolean tryAddItemToInventory(ItemStack stack, IInventory inventory, boolean doAdd) {
        ItemStack invStack;
        int i;
        int maxStackSize = Math.min(stack.getMaxStackSize(), inventory.getInventoryStackLimit());
        if (!doAdd) {
            stack = stack.copy();
        }
        if (stack.isStackable()) {
            for (i = 0; i < inventory.getSizeInventory(); ++i) {
                int amount;
                ItemStack testStack;
                invStack = inventory.getStackInSlot(i);
                if (StackUtils.matches(stack, invStack) && invStack.stackSize < maxStackSize && inventory.isItemValidForSlot(i, testStack = StackUtils.copyStack(stack, amount = Math.min(invStack.stackSize + stack.stackSize, maxStackSize)))) {
                    stack.stackSize -= testStack.stackSize - invStack.stackSize;
                    if (doAdd) {
                        inventory.setInventorySlotContents(i, testStack);
                    }
                }
                if (stack.stackSize > 0) continue;
                return true;
            }
        }
        for (i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack testStack;
            invStack = inventory.getStackInSlot(i);
            if (invStack == null && inventory.isItemValidForSlot(i, testStack = StackUtils.copyStack(stack, Math.min(stack.stackSize, maxStackSize)))) {
                stack.stackSize -= testStack.stackSize;
                if (doAdd) {
                    inventory.setInventorySlotContents(i, testStack);
                }
            }
            if (stack.stackSize > 0) continue;
            return true;
        }
        return false;
    }
}

