/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.mcft.copy.betterstorage.BetterStorage;
import net.mcft.copy.betterstorage.addon.thaumcraft.GuiThaumiumChest;
import net.mcft.copy.betterstorage.client.gui.GuiBetterStorage;
import net.mcft.copy.betterstorage.client.gui.GuiCraftingStation;
import net.mcft.copy.betterstorage.client.gui.GuiCrate;
import net.mcft.copy.betterstorage.container.ContainerKeyring;
import net.mcft.copy.betterstorage.inventory.InventoryCardboardBox;
import net.mcft.copy.betterstorage.inventory.InventoryWrapper;
import net.mcft.copy.betterstorage.network.packet.PacketOpenGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;

public final class PlayerUtils {
    private PlayerUtils() {
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getLocalPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }

    public static void openGui(EntityPlayer pl, String name, int columns, int rows, String title, Container container) {
        EntityPlayerMP player = (EntityPlayerMP)pl;
        if (title == null) {
            title = "";
        }
        player.closeContainer();
        player.getNextWindowId();
        BetterStorage.networkChannel.sendTo(new PacketOpenGui(player.currentWindowId, name, columns, rows, title), player);
        player.openContainer = container;
        player.openContainer.windowId = player.currentWindowId;
        player.openContainer.addCraftingToCrafters((ICrafting)player);
    }

    @SideOnly(value=Side.CLIENT)
    public static void openGui(EntityPlayer player, String name, int columns, int rows, String title) {
        GuiScreen gui = PlayerUtils.createGuiFromName(player, name, columns, rows, title);
        Minecraft.getMinecraft().displayGuiScreen(gui);
    }

    @SideOnly(value=Side.CLIENT)
    private static GuiScreen createGuiFromName(EntityPlayer player, String name, int columns, int rows, String title) {
        boolean localized;
        boolean bl = localized = !title.isEmpty();
        if (!localized) {
            title = name;
        }
        if (name.equals("container.betterstorage.crate")) {
            return new GuiCrate(player, rows, title, localized);
        }
        if (name.equals("container.betterstorage.keyring")) {
            return new GuiBetterStorage(new ContainerKeyring(player, title, columns));
        }
        if (name.startsWith("container.betterstorage.thaumiumChest")) {
            return new GuiThaumiumChest(player, columns, rows, title, localized);
        }
        if (name.equals("container.betterstorage.cardboardBox")) {
            return new GuiBetterStorage(player, columns, rows, new InventoryWrapper(new InventoryCardboardBox(new ItemStack[columns * rows]), title, localized));
        }
        if (name.equals("container.betterstorage.craftingStation")) {
            return new GuiCraftingStation(player, title, localized);
        }
        return new GuiBetterStorage(player, columns, rows, title, localized);
    }
}

