/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class RenderUtils {
    private static final ResourceLocation glint = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderUtils() {
    }

    public static void renderItemIn3d(ItemStack stack) {
        TextureManager textureManager = Minecraft.getMinecraft().getTextureManager();
        if (textureManager == null) {
            return;
        }
        Item item = stack.getItem();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.03125f);
        int passes = item.getRenderPasses(stack.getItemDamage());
        for (int pass = 0; pass < passes; ++pass) {
            textureManager.bindTexture(stack.getItemSpriteNumber() == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture);
            IIcon icon = item.getIcon(stack, pass);
            float minU = icon.getMinU();
            float maxU = icon.getMaxU();
            float minV = icon.getMinV();
            float maxV = icon.getMaxV();
            RenderUtils.setColorFromInt(item.getColorFromItemStack(stack, pass));
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
        }
        if (stack.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            textureManager.bindTexture(glint);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.getSystemTime() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.getSystemTime() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)256, (int)256, (float)0.0625f);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel, int textureWidth, int textureHeight) {
        float xScale = 1.0f / (float)textureWidth;
        float yScale = 1.0f / (float)textureHeight;
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)(x + 0), (double)(y + height), (double)zLevel, (double)((float)(u + 0) * xScale), (double)((float)(v + height) * yScale));
        tess.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)(v + height) * yScale));
        tess.addVertexWithUV((double)(x + width), (double)(y + 0), (double)zLevel, (double)((float)(u + width) * xScale), (double)((float)(v + 0) * yScale));
        tess.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)zLevel, (double)((float)(u + 0) * xScale), (double)((float)(v + 0) * yScale));
        tess.draw();
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(texture);
    }
}

