/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.mcft.copy.betterstorage.attachment.Attachments;
import net.mcft.copy.betterstorage.container.ContainerBetterStorage;
import net.mcft.copy.betterstorage.inventory.InventoryTileEntity;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.RandomUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class WorldUtils {
    private WorldUtils() {
    }

    @SideOnly(value=Side.CLIENT)
    public static World getLocalWorld() {
        return Minecraft.getMinecraft().theWorld;
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double x = entity.xCoord;
        double y = entity.yCoord;
        double z = entity.zCoord;
        return AxisAlignedBB.getBoundingBox((double)(x - minX), (double)(y - minY), (double)(z - minZ), (double)(x + maxX + 1.0), (double)(y + maxY + 1.0), (double)(z + maxZ + 1.0));
    }

    public static AxisAlignedBB getAABB(TileEntity entity, double radius) {
        return WorldUtils.getAABB(entity, radius, radius, radius, radius, radius, radius);
    }

    public static EntityItem spawnItem(World world, double x, double y, double z, ItemStack stack) {
        if (stack == null || stack.stackSize <= 0) {
            return null;
        }
        EntityItem item = new EntityItem(world, x, y, z, stack);
        world.spawnEntityInWorld((Entity)item);
        return item;
    }

    public static EntityItem spawnItemWithMotion(World world, double x, double y, double z, ItemStack stack) {
        EntityItem item = WorldUtils.spawnItem(world, x, y, z, stack);
        if (item != null) {
            item.motionX = RandomUtils.getGaussian() * (double)0.05f;
            item.motionY = RandomUtils.getGaussian() * (double)0.05f + (double)0.2f;
            item.motionZ = RandomUtils.getGaussian() * (double)0.05f;
        }
        return item;
    }

    public static EntityItem dropStackFromBlock(World world, int x, int y, int z, ItemStack stack) {
        float itemX = (float)x + RandomUtils.getFloat(0.1f, 0.9f);
        float itemY = (float)y + RandomUtils.getFloat(0.1f, 0.9f);
        float itemZ = (float)z + RandomUtils.getFloat(0.1f, 0.9f);
        return WorldUtils.spawnItemWithMotion(world, itemX, itemY, itemZ, stack);
    }

    public static EntityItem dropStackFromBlock(TileEntity te, ItemStack stack) {
        return WorldUtils.dropStackFromBlock(te.getWorldObj(), te.xCoord, te.yCoord, te.zCoord, stack);
    }

    public static EntityItem dropStackFromEntity(Entity entity, ItemStack stack, float speed) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        if (player == null) {
            double y = entity.posY + (double)entity.getEyeHeight() - 0.3;
            EntityItem item = WorldUtils.spawnItem(entity.worldObj, entity.posX, y, entity.posZ, stack);
            if (item == null) {
                return null;
            }
            item.delayBeforeCanPickup = 40;
            float f1 = RandomUtils.getFloat(0.5f);
            float f2 = RandomUtils.getFloat((float)Math.PI * 2);
            item.motionX = -MathHelper.sin((float)f2) * f1;
            item.motionY = 0.2;
            item.motionZ = MathHelper.cos((float)f2) * f1;
            return item;
        }
        EntityItem item = player.dropPlayerItemWithRandomChoice(stack, true);
        if (item != null) {
            item.motionX *= (double)(speed / 4.0f);
            item.motionZ *= (double)(speed / 4.0f);
        }
        return item;
    }

    public static <T> boolean is(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        return tileClass.isInstance(world.getTileEntity(x, y, z));
    }

    public static <T> T get(IBlockAccess world, int x, int y, int z, Class<T> tileClass) {
        TileEntity t = world.getTileEntity(x, y, z);
        return (T)(tileClass.isInstance(t) ? t : null);
    }

    public static boolean isTileEntityUsableByPlayer(TileEntity entity, EntityPlayer player) {
        return entity.getWorldObj().getTileEntity(entity.xCoord, entity.yCoord, entity.zCoord) == entity && player.getDistanceSq((double)entity.xCoord + 0.5, (double)entity.yCoord + 0.5, (double)entity.zCoord + 0.5) <= 64.0;
    }

    public static int syncPlayersUsing(TileEntity te, int playersUsing, IInventory playerInventory) {
        if (!te.getWorldObj().isRemote && playersUsing != 0) {
            playersUsing = 0;
            List players = te.getWorldObj().getEntitiesWithinAABB(EntityPlayer.class, WorldUtils.getAABB(te, 5.0));
            for (EntityPlayer player : players) {
                if (!(player.openContainer instanceof ContainerBetterStorage)) continue;
                IInventory inventory = ((ContainerBetterStorage)player.openContainer).inventory;
                if (inventory == playerInventory) {
                    ++playersUsing;
                    continue;
                }
                if (!(inventory instanceof InventoryTileEntity) || ((InventoryTileEntity)inventory).mainTileEntity != te) continue;
                ++playersUsing;
            }
        }
        return playersUsing;
    }

    public static int syncPlayersUsing(TileEntityContainer te, int numUsingPlayers) {
        return WorldUtils.syncPlayersUsing(te, numUsingPlayers, te.getPlayerInventory());
    }

    public static void notifyBlocksAround(World world, int x, int y, int z) {
        Block block = world.getBlock(x, y, z);
        world.notifyBlocksOfNeighborChange(x, y, z, block);
        world.notifyBlocksOfNeighborChange(x + 1, y, z, block);
        world.notifyBlocksOfNeighborChange(x - 1, y, z, block);
        world.notifyBlocksOfNeighborChange(x, y + 1, z, block);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, block);
        world.notifyBlocksOfNeighborChange(x, y, z + 1, block);
        world.notifyBlocksOfNeighborChange(x, y, z - 1, block);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, float partialTicks) {
        Attachments.playerLocal.set(player);
        double range = player.worldObj.isRemote ? (double)Minecraft.getMinecraft().playerController.getBlockReachDistance() : ((EntityPlayerMP)player).theItemInWorldManager.getBlockReachDistance();
        Vec3 start = Vec3.createVectorHelper((double)player.posX, (double)(player.posY + 1.62 - (double)player.yOffset), (double)player.posZ);
        Vec3 look = player.getLook(1.0f);
        Vec3 end = start.addVector(look.xCoord * range, look.yCoord * range, look.zCoord * range);
        MovingObjectPosition target = player.worldObj.rayTraceBlocks(start, end);
        Attachments.playerLocal.remove();
        return target;
    }
}

