/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.addon.nei;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.mcft.copy.betterstorage.api.crafting.BetterStorageCrafting;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.IStationRecipe;
import net.mcft.copy.betterstorage.api.crafting.RecipeBounds;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.client.gui.GuiCraftingStation;
import net.mcft.copy.betterstorage.misc.Resources;
import net.mcft.copy.betterstorage.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIRecipeHandler
extends TemplateRecipeHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private List<CachedStationRecipe> cachedRecipes = null;

    public String getRecipeName() {
        return "Crafting Station";
    }

    public String getOverlayIdentifier() {
        return "betterstorage.craftingStation";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCraftingStation.class;
    }

    public String getGuiTexture() {
        return Resources.containerCraftingStation.toString();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 23, 24, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)this.getOverlayIdentifier()) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)this.getOverlayIdentifier());
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(Resources.containerCraftingStation);
        RenderUtils.drawTexturedModalRect(0, 0, 5, 11, 166, 64, 0.0f, 256, 256);
    }

    public void drawExtras(int recipe) {
        super.drawExtras(recipe);
        CachedStationRecipe cached = (CachedStationRecipe)((Object)this.arecipes.get(recipe));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (cached.craftingTime >= 20) {
            this.drawProgressBar(71, 22, 176, 0, 24, 18, cached.craftingTime, 0);
            int min = cached.craftingTime / 20 / 60;
            int sec = cached.craftingTime / 20 % 60;
            String str = "";
            if (min > 0) {
                str = str + min + "m";
            }
            if (sec > 0) {
                str = str + sec + "s";
            }
            int strX = (168 - this.mc.field_71466_p.func_78256_a(str)) / 2;
            int strY = 17 - this.mc.field_71466_p.field_78288_b / 2;
            this.mc.field_71466_p.func_78276_b(str, strX, strY, 0x444444);
        }
        if (cached.requiredExperience > 0) {
            String str = Integer.toString(cached.requiredExperience);
            int strX = (168 - this.mc.field_71466_p.func_78256_a(str)) / 2;
            int strY = 47 - this.mc.field_71466_p.field_78288_b / 2;
            this.mc.field_71466_p.func_78276_b(str, strX - 1, strY, 0x444444);
            this.mc.field_71466_p.func_78276_b(str, strX + 1, strY, 0x444444);
            this.mc.field_71466_p.func_78276_b(str, strX, strY - 1, 0x444444);
            this.mc.field_71466_p.func_78276_b(str, strX, strY + 1, 0x444444);
            this.mc.field_71466_p.func_78276_b(str, strX, strY, 8453920);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(this.getRecipes());
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CachedStationRecipe recipe : this.getRecipes()) {
            if (!recipe.outputs(result)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (CachedStationRecipe recipe : this.getRecipes()) {
            if (!recipe.uses(ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    public void onUpdate() {
        if (!NEIClientUtils.shiftKey() && ++this.cycleticks % 20 == 0) {
            for (TemplateRecipeHandler.CachedRecipe recipe : this.arecipes) {
                ((CachedStationRecipe)recipe).cycle();
            }
        }
    }

    public List<CachedStationRecipe> getRecipes() {
        if (this.cachedRecipes == null) {
            this.cachedRecipes = new ArrayList<CachedStationRecipe>();
            for (IStationRecipe recipe : BetterStorageCrafting.recipes) {
                List<IRecipeInput[]> sampleInput = recipe.getSampleInputs();
                if (sampleInput == null) continue;
                this.cachedRecipes.add(new CachedStationRecipe(recipe));
            }
        }
        return this.cachedRecipes;
    }

    public class CachedStationRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final IStationRecipe recipe;
        private final List<PositionedStack> ingridients;
        private final List<PositionedStack> output;
        private final List<IRecipeInput[]> sampleInput;
        private List<IRecipeInput> possibleInputs;
        private List<ItemStack> possibleOutputs;
        private int requiredExperience;
        private int craftingTime;
        int cycleIndex;

        public CachedStationRecipe(IStationRecipe recipe) {
            super((TemplateRecipeHandler)NEIRecipeHandler.this);
            this.ingridients = new ArrayList<PositionedStack>();
            this.output = new ArrayList<PositionedStack>();
            this.cycleIndex = 0;
            this.recipe = recipe;
            this.sampleInput = recipe.getSampleInputs();
            this.possibleInputs = recipe.getPossibleInputs();
            this.possibleOutputs = recipe.getPossibleOutputs();
            if (this.possibleInputs == null) {
                this.possibleInputs = new ArrayList<IRecipeInput>();
                for (IRecipeInput[] inputArray : this.sampleInput) {
                    for (IRecipeInput input : inputArray) {
                        if (input == null) continue;
                        this.possibleInputs.add(input);
                    }
                }
            }
            if (this.possibleOutputs == null) {
                this.possibleOutputs = new ArrayList<ItemStack>();
                for (IRecipeInput[] inputArray : this.sampleInput) {
                    ItemStack[] stackArray = new ItemStack[inputArray.length];
                    for (int i = 0; i < inputArray.length; ++i) {
                        if (inputArray[i] == null) continue;
                        stackArray[i] = inputArray[i].getPossibleMatches().get(0);
                    }
                    for (ItemStack stack : recipe.checkMatch(stackArray, new RecipeBounds(stackArray)).getOutput()) {
                        if (stack == null) continue;
                        this.possibleOutputs.add(stack);
                    }
                }
            }
            this.cycle();
        }

        public void cycle() {
            this.cycleIndex = (this.cycleIndex + 1) % this.sampleInput.size();
            IRecipeInput[] inputArray = this.sampleInput.get(this.cycleIndex);
            ItemStack[] stackArray = new ItemStack[inputArray.length];
            this.ingridients.clear();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int index = x + y * 3;
                    IRecipeInput input = inputArray[index];
                    if (input == null) continue;
                    List<ItemStack> possibleMatches = input.getPossibleMatches();
                    this.ingridients.add(new PositionedStack(possibleMatches, x * 18 + 12, y * 18 + 6));
                    stackArray[index] = possibleMatches.get(0);
                }
            }
            StationCrafting crafting = this.recipe.checkMatch(stackArray, new RecipeBounds(stackArray));
            if (crafting == null) {
                throw new Error("Recipe " + this.recipe.getClass().getSimpleName() + " didn't match sample input.");
            }
            this.requiredExperience = crafting.getRequiredExperience();
            this.craftingTime = crafting.getCraftingTime();
            this.output.clear();
            ItemStack[] outputArray = crafting.getOutput();
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    if (x + y * 3 >= outputArray.length || outputArray[x + y * 3] == null) continue;
                    this.output.add(new PositionedStack((Object)outputArray[x + y * 3], x * 18 + 102, y * 18 + 6));
                }
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIRecipeHandler.this.cycleticks / 20, this.ingridients);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.output;
        }

        public boolean outputs(ItemStack result) {
            for (ItemStack output : this.possibleOutputs) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)output, (ItemStack)result)) continue;
                return true;
            }
            return false;
        }

        public boolean uses(ItemStack ingredient) {
            for (IRecipeInput input : this.possibleInputs) {
                if (!input.matches(ingredient)) continue;
                return true;
            }
            return false;
        }
    }
}

