/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcft.copy.betterstorage.content.BetterStorageItems;
import net.mcft.copy.betterstorage.item.ItemBetterStorage;
import net.mcft.copy.betterstorage.utils.LanguageUtils;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class ItemBucketSlime
extends ItemBetterStorage {
    private static Map<String, Handler> handlers = new HashMap<String, Handler>();
    private IIcon empty;

    public ItemBucketSlime() {
        this.func_77642_a(Items.field_151133_ar);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.empty = iconRegister.func_94245_a("betterstorage:bucketSlime_empty");
        for (Handler handler : handlers.values()) {
            handler.registerIcon(iconRegister);
        }
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            Handler handler = ItemBucketSlime.getHandler(stack);
            return handler != null ? handler.icon : this.empty;
        }
        return this.empty;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.func_77948_v() || pass == 0 && StackUtils.has(stack, "Effects");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        NBTTagList effectList;
        String id = ItemBucketSlime.getSlimeId(stack);
        Handler handler = ItemBucketSlime.getHandler(id);
        String name = StackUtils.get(stack, null, "Slime", "name");
        if (name != null || advancedTooltips) {
            list.add("Contains: " + (name != null ? "\"" + name + "\"" + (advancedTooltips ? " (" + id + ")" : "") : id));
        }
        if ((effectList = (NBTTagList)StackUtils.getTag(stack, "Effects")) != null && handler != null) {
            int max = advancedTooltips || GuiScreen.func_146272_n() ? 6 : 3;
            for (int i = 0; i < Math.min(effectList.func_74745_c(), max); ++i) {
                PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i));
                Potion potion = Potion.field_76425_a[effect.func_76456_a()];
                int duration = (int)((float)effect.func_76459_b() * handler.durationMultiplier());
                StringBuilder str = new StringBuilder().append(potion.func_76398_f() ? EnumChatFormatting.RED : EnumChatFormatting.GRAY).append(StatCollector.func_74838_a((String)effect.func_76453_d()));
                if (effect.func_76458_c() > 0) {
                    str.append(" ").append(StatCollector.func_74838_a((String)("potion.potency." + effect.func_76458_c())));
                }
                str.append(" (").append(StringUtils.func_76337_a((int)duration)).append(")");
                list.add(str.toString());
            }
            int more = effectList.func_74745_c() - max;
            if (more > 0) {
                list.add(EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + LanguageUtils.translateTooltip("bucketSlime.more." + (more == 1 ? "1" : "x"), "%X%", Integer.toString(more)));
            }
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        String id = ItemBucketSlime.getSlimeId(stack);
        String name = StackUtils.get(stack, null, "Slime", "name");
        Entity entity = EntityList.func_75620_a((String)id, (World)world);
        Handler handler = ItemBucketSlime.getHandler(id);
        if (entity != null && handler != null && entity instanceof EntityLiving) {
            EntityLiving slime = (EntityLiving)entity;
            float rotation = MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f));
            slime.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, rotation, 0.0f);
            slime.field_70759_as = slime.field_70761_aq = rotation;
            if (name != null) {
                slime.func_94058_c(name);
            }
            handler.setSize(slime, 1);
            NBTTagList effectList = (NBTTagList)StackUtils.getTag(stack, "Effects");
            if (effectList != null) {
                for (int i = 0; i < effectList.func_74745_c(); ++i) {
                    slime.func_70690_d(PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i)));
                }
            }
            world.func_72838_d((Entity)slime);
            slime.func_85030_a("mob.slime.big", 1.2f, 0.6f);
            player.func_70062_b(0, new ItemStack(Items.field_151133_ar));
        }
        return true;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.drink;
    }

    public int func_77626_a(ItemStack stack) {
        return 48;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        Handler handler = ItemBucketSlime.getHandler(stack);
        if (handler != null) {
            player.func_71024_bL().func_75122_a(handler.foodAmount(), handler.saturationAmount());
            NBTTagList effectList = (NBTTagList)StackUtils.getTag(stack, "Effects");
            if (effectList != null) {
                for (int i = 0; i < effectList.func_74745_c(); ++i) {
                    PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)effectList.func_150305_b(i));
                    int duration = (int)((float)effect.func_76459_b() * handler.durationMultiplier());
                    effect = new PotionEffect(effect.func_76456_a(), duration, effect.func_76458_c());
                    player.func_70690_d(effect);
                }
            }
            handler.onEaten(player, false);
        }
        return new ItemStack(Items.field_151133_ar);
    }

    public static void pickUpSlime(EntityPlayer player, EntityLiving slime) {
        Collection effects;
        Handler handler = ItemBucketSlime.getHandler(slime);
        if (slime.field_70128_L || handler == null || handler.getSize(slime) != 1) {
            return;
        }
        ItemStack stack = new ItemStack((Item)BetterStorageItems.slimeBucket);
        String entityId = EntityList.func_75621_b((Entity)slime);
        if (!entityId.equals("Slime")) {
            StackUtils.set(stack, entityId, "Slime", "id");
        }
        if (slime.func_94056_bM()) {
            StackUtils.set(stack, slime.func_94057_bL(), "Slime", "name");
        }
        if (!(effects = slime.func_70651_bq()).isEmpty()) {
            NBTTagList effectList = new NBTTagList();
            for (PotionEffect effect : effects) {
                effectList.func_74742_a((NBTBase)effect.func_82719_a(new NBTTagCompound()));
            }
            StackUtils.set(stack, (NBTBase)effectList, "Effects");
        }
        if (--player.func_71045_bC().field_77994_a <= 0) {
            player.func_70062_b(0, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, true);
        } else {
            ((EntityPlayerMP)player).field_71069_bz.func_75142_b();
        }
        slime.func_85030_a("mob.slime.big", 1.2f, 0.8f);
        slime.field_70128_L = true;
    }

    public static String getSlimeId(ItemStack stack) {
        return StackUtils.get(stack, "Slime", "Slime", "id");
    }

    public static void registerHandler(Handler handler) {
        handlers.put(handler.entityName, handler);
    }

    public static Handler getHandler(String id) {
        return handlers.get(id);
    }

    public static Handler getHandler(EntityLiving slime) {
        return ItemBucketSlime.getHandler(EntityList.func_75621_b((Entity)slime));
    }

    public static Handler getHandler(ItemStack stack) {
        return ItemBucketSlime.getHandler(ItemBucketSlime.getSlimeId(stack));
    }

    static {
        ItemBucketSlime.registerHandler(new Handler("slime", "Slime"){

            @Override
            public int foodAmount() {
                return 3;
            }

            @Override
            public float saturationAmount() {
                return 0.2f;
            }
        });
        ItemBucketSlime.registerHandler(new Handler("magmaCube", "LavaSlime"){

            @Override
            public float durationMultiplier() {
                return 0.4f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                player.func_70015_d(2);
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, (potionEffects ? 10 : 20) * 20, potionEffects ? 2 : 3));
                player.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, (potionEffects ? 24 : 32) * 20, 0));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("mazeSlime", "TwilightForest.Maze Slime"){

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                player.func_70097_a(DamageSource.field_76376_m, 3.0f);
                player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, (potionEffects ? 4 : 8) * 20, 0));
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, (potionEffects ? 4 : 8) * 20, 1));
                player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 600, 1));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("pinkSlime", "MineFactoryReloaded.mfrEntityPinkSlime"){

            @Override
            public int foodAmount() {
                return 6;
            }

            @Override
            public float saturationAmount() {
                return 0.75f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                super.onEaten(player, potionEffects);
                player.func_70690_d(new PotionEffect(Potion.field_76434_w.field_76415_H, (potionEffects ? 40 : 60) * 20, 4));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("thaumicSlime", "Thaumcraft.ThaumSlime"){
            private int potionFluxId = -1;

            @Override
            public float durationMultiplier() {
                return 1.0f;
            }

            @Override
            public void onEaten(EntityPlayer player, boolean potionEffects) {
                if (this.potionFluxId == -1) {
                    for (Potion potion : Potion.field_76425_a) {
                        if (potion == null || potion.func_76393_a() != "potion.fluxtaint") continue;
                        this.potionFluxId = potion.field_76415_H;
                        break;
                    }
                    if (this.potionFluxId == -1) {
                        this.potionFluxId = Potion.field_82731_v.field_76415_H;
                    }
                }
                super.onEaten(player, potionEffects);
                player.func_70690_d(new PotionEffect(this.potionFluxId, 160, 0));
            }
        });
        ItemBucketSlime.registerHandler(new Handler("blueSlime", "TConstruct.EdibleSlime"){

            @Override
            public float durationMultiplier() {
                return 0.2f;
            }
        });
    }

    public static class Handler {
        public final String name;
        public final String entityName;
        public IIcon icon;

        public Handler(String name, String entityName) {
            this.name = name;
            this.entityName = entityName;
        }

        public void registerIcon(IIconRegister iconRegister) {
            this.icon = iconRegister.func_94245_a("betterstorage:bucketSlime_" + this.name);
        }

        public int getSize(EntityLiving slime) {
            return slime.func_70096_w().func_75683_a(16);
        }

        public void setSize(EntityLiving slime, int size) {
            NBTTagCompound compound = new NBTTagCompound();
            slime.func_70109_d(compound);
            compound.func_74768_a("Size", size - 1);
            slime.func_70020_e(compound);
        }

        public int foodAmount() {
            return 4;
        }

        public float saturationAmount() {
            return 0.3f;
        }

        public float durationMultiplier() {
            return 0.25f;
        }

        public void onEaten(EntityPlayer player, boolean potionEffects) {
            player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, (potionEffects ? 6 : 16) * 20, 1));
        }
    }
}

