/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.item.recipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.mcft.copy.betterstorage.api.crafting.ICraftingSource;
import net.mcft.copy.betterstorage.api.crafting.IRecipeInput;
import net.mcft.copy.betterstorage.api.crafting.RecipeInputBase;
import net.mcft.copy.betterstorage.api.crafting.StationCrafting;
import net.mcft.copy.betterstorage.config.GlobalConfig;
import net.mcft.copy.betterstorage.inventory.InventoryCraftingStation;
import net.mcft.copy.betterstorage.utils.StackUtils;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class VanillaStationCrafting
extends StationCrafting {
    public VanillaStationCrafting(World world, IRecipe recipe, ItemStack[] input, ItemStack output) {
        super(new ItemStack[]{null, null, null, null, output}, VanillaStationCrafting.createRecipeInput(world, recipe, input));
    }

    private static IRecipeInput[] createRecipeInput(World world, IRecipe recipe, ItemStack[] input) {
        IRecipeInput[] requiredInput = new IRecipeInput[9];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == null) continue;
            requiredInput[i] = new VanillaRecipeInput(world, recipe, input, i);
        }
        return requiredInput;
    }

    @Override
    public boolean canCraft(ICraftingSource source) {
        return source.getPlayer() != null || (Boolean)GlobalConfig.enableStationAutoCraftingSetting.getValue() == false;
    }

    public static VanillaStationCrafting findVanillaRecipe(InventoryCraftingStation inv) {
        World world = inv.entity != null ? inv.entity.func_145831_w() : WorldUtils.getLocalWorld();
        InventoryCrafting crafting = new InventoryCrafting((Container)new FakeContainer(), 3, 3);
        for (int i = 0; i < inv.crafting.length; ++i) {
            crafting.func_70299_a(i, ItemStack.func_77944_b((ItemStack)inv.crafting[i]));
        }
        IRecipe recipe = VanillaStationCrafting.findRecipe(crafting, world);
        if (recipe == null) {
            return null;
        }
        return new VanillaStationCrafting(world, recipe, inv.crafting, recipe.func_77572_b(crafting));
    }

    private static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!recipe.func_77569_a(crafting, world)) continue;
            return recipe;
        }
        return null;
    }

    private static class FakeContainer
    extends Container {
        private FakeContainer() {
        }

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }
    }

    private static class VanillaRecipeInput
    extends RecipeInputBase {
        private final World world;
        private final IRecipe recipe;
        private final int slot;
        private final InventoryCrafting crafting;
        private final ItemStack expectedOutput;

        public VanillaRecipeInput(World world, IRecipe recipe, ItemStack[] input, int slot) {
            this.world = world;
            this.recipe = recipe;
            this.slot = slot;
            this.crafting = new InventoryCrafting((Container)new FakeContainer(), 3, 3);
            for (int i = 0; i < input.length; ++i) {
                this.crafting.func_70299_a(i, ItemStack.func_77944_b((ItemStack)input[i]));
            }
            ItemStack output = recipe.func_77572_b(this.crafting);
            if (output == null) {
                throw new IllegalArgumentException(recipe.getClass() + " returned null for getCraftingResult.");
            }
            this.expectedOutput = output.func_77946_l();
        }

        @Override
        public int getAmount() {
            return 1;
        }

        @Override
        public boolean matches(ItemStack stack) {
            ItemStack stackBefore = this.crafting.func_70301_a(this.slot);
            this.crafting.func_70299_a(this.slot, stack);
            boolean matches = this.recipe.func_77569_a(this.crafting, this.world) && StackUtils.matches(this.expectedOutput, this.recipe.func_77572_b(this.crafting));
            this.crafting.func_70299_a(this.slot, stackBefore);
            return matches;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getPossibleMatches() {
            return null;
        }
    }
}

