/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile;

import net.mcft.copy.betterstorage.attachment.IHasAttachments;
import net.mcft.copy.betterstorage.tile.TileBetterStorage;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileContainerBetterStorage
extends TileBetterStorage {
    public boolean hasTileEntity(int metadata) {
        return true;
    }

    protected TileContainerBetterStorage(Material material) {
        super(material);
        this.field_149758_A = true;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventPar) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null ? te.func_145842_c(eventId, eventPar) : false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        this.getContainer(world, x, y, z).onBlockPlaced(player, stack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.getContainer(world, x, y, z).onBlockActivated(player, side, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!this.getContainer(world, x, y, z).onBlockBreak(player)) {
            return false;
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container != null) {
            container.onBlockDestroyed();
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ItemStack pick;
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container instanceof IHasAttachments && (pick = ((IHasAttachments)((Object)container)).getAttachments().pick(target)) != null) {
            return pick;
        }
        pick = super.getPickBlock(target, world, x, y, z);
        return container.onPickBlock(pick, target);
    }

    public int func_149736_g(World world, int x, int y, int z, int direction) {
        return TileEntityContainer.getContainerComparatorSignalStrength((IBlockAccess)world, x, y, z);
    }

    private TileEntityContainer getContainer(World world, int x, int y, int z) {
        return WorldUtils.get((IBlockAccess)world, x, y, z, TileEntityContainer.class);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntityContainer container = this.getContainer(world, x, y, z);
        if (container != null) {
            container.onNeighborUpdate(neighborBlock);
        }
    }
}

