/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.crate;

import net.mcft.copy.betterstorage.misc.Region;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CratePileMap {
    public Region region;
    private byte[] map;
    private Region mapRegion;

    private CratePileMap(Region region, byte[] map, Region mapRegion) {
        this.region = region;
        this.map = map;
        this.mapRegion = mapRegion;
    }

    public CratePileMap(TileEntity entity) {
        this.region = new Region(entity);
        this.map = new byte[1];
        this.mapRegion = this.region.clone();
        this.mapRegion.minY /= 8;
        this.mapRegion.maxY /= 8;
        this.resize();
        this.add(entity);
    }

    private int getIndex(int width, int depth, int x, int y, int z) {
        return y + x * depth + z * depth * width;
    }

    private int getIndex(int x, int y, int z) {
        return this.getIndex(this.mapRegion.width(), this.mapRegion.depth(), x, y, z);
    }

    private boolean internalGet(int x, int y, int z) {
        byte b = this.map[this.getIndex(x, y / 8, z)];
        return (b >> y % 8 & 1) > 0;
    }

    private void internalSet(int x, int y, int z, boolean value) {
        int index = this.getIndex(x, y / 8, z);
        if (value) {
            int n = index;
            this.map[n] = (byte)(this.map[n] | 1 << y % 8);
        } else {
            int n = index;
            this.map[n] = (byte)(this.map[n] & ~(1 << y % 8));
        }
    }

    private void resize(Region region) {
        byte[] newMap = new byte[region.width() * region.depth() * region.height()];
        int minX = Math.max(this.mapRegion.minX, region.minX);
        int maxX = Math.min(this.mapRegion.maxX, region.maxX);
        int minY = Math.max(this.mapRegion.minY, region.minY);
        int maxY = Math.min(this.mapRegion.maxY, region.maxY);
        int minZ = Math.max(this.mapRegion.minZ, region.minZ);
        int maxZ = Math.min(this.mapRegion.maxZ, region.maxZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                int srcPos = this.getIndex(x - this.mapRegion.minX, minY - this.mapRegion.minY, z - this.mapRegion.minZ);
                int destPos = this.getIndex(region.width(), region.depth(), x - region.minX, minY - region.minY, z - region.minZ);
                int length = maxY - minY + 1;
                System.arraycopy(this.map, srcPos, newMap, destPos, length);
            }
        }
        this.map = newMap;
        this.mapRegion = region;
    }

    private void resize() {
        Region newRegion = this.region.clone();
        newRegion.expand(2, 0, 2, 2, 2, 2);
        newRegion.minY /= 8;
        newRegion.maxY /= 8;
        this.resize(newRegion);
    }

    private boolean checkCuboid(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.get(x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean get(int x, int y, int z) {
        if (!this.region.contains(x, y, z)) {
            return false;
        }
        return this.internalGet(x - this.mapRegion.minX, y - this.mapRegion.minY * 8, z - this.mapRegion.minZ);
    }

    public void set(int x, int y, int z, boolean value) {
        if (this.region.contains(x, y, z)) {
            this.internalSet(x - this.mapRegion.minX, y - this.mapRegion.minY * 8, z - this.mapRegion.minZ, value);
            if (!value) {
                int minX = this.region.minX++;
                int minY = this.region.minY;
                int minZ = this.region.minZ;
                int maxX = this.region.maxX;
                int maxY = this.region.maxY;
                int maxZ = this.region.maxZ;
                if (x != minX || this.checkCuboid(minX, minY, minZ, minX, maxY, maxZ)) {
                    // empty if block
                }
                if (y == minY && this.checkCuboid(minX, minY, minZ, maxX, minY, maxZ)) {
                    ++this.region.minY;
                }
                if (z == minZ && this.checkCuboid(minX, minY, minZ, maxX, maxY, minZ)) {
                    ++this.region.minZ;
                }
                if (x == maxX && this.checkCuboid(maxX, minY, minZ, maxX, maxY, maxZ)) {
                    --this.region.maxX;
                }
                if (y == maxY && this.checkCuboid(minX, maxY, minZ, maxX, maxY, maxZ)) {
                    --this.region.maxY;
                }
                if (z == maxZ && this.checkCuboid(minX, minY, maxZ, maxX, maxY, maxZ)) {
                    --this.region.maxZ;
                }
                if (this.region.minX - this.mapRegion.minX > 4 || this.mapRegion.maxX - this.region.maxX > 4 || this.region.minY / 8 - this.mapRegion.minY > 2 || this.mapRegion.maxY / 8 - this.region.maxY > 2 || this.region.minZ - this.mapRegion.minZ > 4 || this.mapRegion.maxZ - this.region.maxZ > 4) {
                    this.resize();
                }
            }
        } else if (value) {
            this.region.expandToContain(x, y, z);
            if (!this.mapRegion.contains(x, y / 8, z)) {
                this.resize();
            }
            this.internalSet(x - this.mapRegion.minX, y - this.mapRegion.minY * 8, z - this.mapRegion.minZ, value);
        }
    }

    public void add(TileEntity entity) {
        this.set(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e, true);
    }

    public void remove(TileEntity entity) {
        this.set(entity.field_145851_c, entity.field_145848_d, entity.field_145849_e, false);
    }

    public void trim() {
        int minX = this.region.minX;
        int minY = this.region.minY;
        int minZ = this.region.minZ;
        int maxX = this.region.maxX;
        int maxY = this.region.maxY;
        int maxZ = this.region.maxZ;
        while (this.checkCuboid(minX, minY, minZ, minX, maxY, maxZ)) {
            ++minX;
        }
        while (this.checkCuboid(minX, minY, minZ, maxX, minY, maxZ)) {
            ++minY;
        }
        while (this.checkCuboid(minX, minY, minZ, maxX, maxY, minZ)) {
            ++minZ;
        }
        while (this.checkCuboid(maxX, minY, minZ, maxX, maxY, maxZ)) {
            --maxX;
        }
        while (this.checkCuboid(minX, maxY, minZ, maxX, maxY, maxZ)) {
            --maxY;
        }
        while (this.checkCuboid(minX, minY, maxZ, maxX, maxY, maxZ)) {
            --maxZ;
        }
        this.region.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("region", (NBTBase)this.region.toCompound());
        compound.func_74773_a("map", this.map);
        compound.func_74782_a("mapRegion", (NBTBase)this.mapRegion.toCompound());
        return compound;
    }

    public static CratePileMap fromCompound(NBTTagCompound compound) {
        Region region = Region.fromCompound(compound.func_74775_l("region"));
        byte[] map = compound.func_74770_j("map");
        Region mapRegion = Region.fromCompound(compound.func_74775_l("mapRegion"));
        return new CratePileMap(region, map, mapRegion);
    }
}

