/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.tile.stand;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.mcft.copy.betterstorage.api.stand.ArmorStandEquipHandler;
import net.mcft.copy.betterstorage.api.stand.BetterStorageArmorStand;
import net.mcft.copy.betterstorage.api.stand.EnumArmorStandRegion;
import net.mcft.copy.betterstorage.api.stand.IArmorStand;
import net.mcft.copy.betterstorage.tile.entity.TileEntityContainer;
import net.mcft.copy.betterstorage.utils.WorldUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;

public class TileEntityArmorStand
extends TileEntityContainer
implements IArmorStand {
    private Map<EnumArmorStandRegion, Map<ArmorStandEquipHandler, ItemStack>> equipment = new HashMap<EnumArmorStandRegion, Map<ArmorStandEquipHandler, ItemStack>>();
    public int rotation = 0;

    public TileEntityArmorStand() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            this.equipment.put(region, new HashMap());
        }
    }

    private void clearItems() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            this.equipment.get((Object)region).clear();
        }
    }

    @Override
    public ItemStack getItem(ArmorStandEquipHandler handler) {
        return this.equipment.get((Object)handler.region).get(handler);
    }

    @Override
    public void setItem(ArmorStandEquipHandler handler, ItemStack item) {
        Map<ArmorStandEquipHandler, ItemStack> items = this.equipment.get((Object)handler.region);
        if (item == null) {
            items.remove(handler);
        } else {
            items.put(handler, item);
        }
        if (this.field_145850_b != null) {
            this.markForUpdate();
            this.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return WorldUtils.getAABB(this, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    @Override
    public String getName() {
        return "container.betterstorage.armorStand";
    }

    @Override
    public boolean canSetCustomTitle() {
        return false;
    }

    @Override
    protected int getSizeContents() {
        return 0;
    }

    @Override
    public void onBlockPlaced(EntityLivingBase player, ItemStack stack) {
        super.onBlockPlaced(player, stack);
        this.rotation = Math.round((player.field_70759_as + 180.0f) * 16.0f / 360.0f);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        int slot = Math.max(0, Math.min(3, (int)(hitY * 2.0f)));
        EnumArmorStandRegion region = EnumArmorStandRegion.values()[slot];
        for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
            ItemStack item = this.getItem(handler);
            if (player.func_70093_af()) {
                ItemStack equipped = handler.getEquipment(player);
                if (item == null && equipped == null || item != null && !handler.isValidItem(player, item) || equipped != null && !handler.isValidItem(player, equipped) || !handler.canSetEquipment(player, item)) continue;
                this.setItem(handler, equipped);
                handler.setEquipment(player, item);
                continue;
            }
            ItemStack holding = player.func_71045_bC();
            if (item == null && holding == null || holding != null && !handler.isValidItem(player, holding)) continue;
            this.setItem(handler, holding);
            player.func_70062_b(0, item);
            break;
        }
        return true;
    }

    @Override
    public ItemStack onPickBlock(ItemStack block, MovingObjectPosition target) {
        int slot = Math.max(0, Math.min(3, (int)((target.field_72307_f.field_72448_b - (double)this.field_145848_d) * 2.0)));
        EnumArmorStandRegion region = EnumArmorStandRegion.values()[slot];
        for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
            ItemStack item = this.getItem(handler);
            if (item == null) continue;
            return item;
        }
        return block;
    }

    @Override
    public void dropContents() {
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                ItemStack item = this.getItem(handler);
                if (item == null) continue;
                WorldUtils.dropStackFromBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, item);
            }
        }
        this.clearItems();
    }

    @Override
    protected int getComparatorSignalStengthInternal() {
        int count = 0;
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                if (this.getItem(handler) == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.write(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.read(packet.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.read(compound);
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.write(compound);
    }

    public void read(NBTTagCompound compound) {
        this.rotation = compound.func_74771_c("rotation");
        this.clearItems();
        NBTBase itemsTag = compound.func_74781_a("Items");
        if (itemsTag instanceof NBTTagList) {
            NBTTagList items = (NBTTagList)itemsTag;
            for (int i = 0; i < items.func_74745_c(); ++i) {
                EnumArmorStandRegion region;
                ArmorStandEquipHandler handler;
                NBTTagCompound item = items.func_150305_b(i);
                int slot = item.func_74771_c("Slot") & 0xFF;
                if (slot < 0 || slot >= EnumArmorStandRegion.values().length || (handler = BetterStorageArmorStand.getEquipHandler(region = EnumArmorStandRegion.values()[slot], "Vanilla")) == null) continue;
                this.setItem(handler, ItemStack.func_77949_a((NBTTagCompound)item));
            }
        } else {
            NBTTagCompound items = (NBTTagCompound)itemsTag;
            for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
                NBTTagCompound regionItems = items.func_74775_l(region.toString());
                for (String id : regionItems.func_150296_c()) {
                    ItemStack item = ItemStack.func_77949_a((NBTTagCompound)regionItems.func_74775_l(id));
                    ArmorStandEquipHandler handler = BetterStorageArmorStand.getEquipHandler(region, id);
                    this.setItem(handler, item);
                }
            }
        }
    }

    public void write(NBTTagCompound compound) {
        compound.func_74774_a("rotation", (byte)this.rotation);
        NBTTagCompound items = new NBTTagCompound();
        for (EnumArmorStandRegion region : EnumArmorStandRegion.values()) {
            NBTTagCompound regionCompound = new NBTTagCompound();
            for (ArmorStandEquipHandler handler : BetterStorageArmorStand.getEquipHandlers(region)) {
                ItemStack item = this.getItem(handler);
                if (item == null) continue;
                regionCompound.func_74782_a(handler.id, (NBTBase)item.func_77955_b(new NBTTagCompound()));
            }
            items.func_74782_a(region.toString(), (NBTBase)regionCompound);
        }
        compound.func_74782_a("Items", (NBTBase)items);
    }
}

