/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.betterstorage.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.IExtendedEntityProperties;

public final class EntityUtils {
    private static Map<Class, String> propertiesLookup = new HashMap<Class, String>();

    private EntityUtils() {
    }

    public static String getIdentifier(Class<? extends IExtendedEntityProperties> propertiesClass) {
        String identifier = propertiesLookup.get(propertiesClass);
        if (identifier == null) {
            try {
                identifier = (String)propertiesClass.getField("identifier").get(null);
            }
            catch (Exception e) {
                throw new Error(e);
            }
            propertiesLookup.put(propertiesClass, identifier);
        }
        return identifier;
    }

    public static <T extends IExtendedEntityProperties> T getProperties(Entity entity, Class<T> propertiesClass) {
        IExtendedEntityProperties properties = entity.getExtendedProperties(EntityUtils.getIdentifier(propertiesClass));
        return (T)(propertiesClass.isInstance(properties) ? properties : null);
    }

    public static <T extends IExtendedEntityProperties> T createProperties(Entity entity, Class<T> propertiesClass) {
        try {
            IExtendedEntityProperties properties = (IExtendedEntityProperties)propertiesClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            entity.registerExtendedProperties(EntityUtils.getIdentifier(propertiesClass), properties);
            return (T)properties;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static <T extends IExtendedEntityProperties> T getOrCreateProperties(Entity entity, Class<T> propertiesClass) {
        T properties = EntityUtils.getProperties(entity, propertiesClass);
        return properties != null ? properties : EntityUtils.createProperties(entity, propertiesClass);
    }
}

