/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BlockIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class SchematicBlock
extends SchematicBlockBase {
    public static final BlockIndex[] RELATIVE_INDEXES = new BlockIndex[]{new BlockIndex(0, -1, 0), new BlockIndex(0, 1, 0), new BlockIndex(0, 0, -1), new BlockIndex(0, 0, 1), new BlockIndex(-1, 0, 0), new BlockIndex(1, 0, 0)};
    public Block block = null;
    public int meta = 0;
    public BuildingPermission defaultPermission = BuildingPermission.ALL;
    public ItemStack[] storedRequirements = new ItemStack[0];
    private boolean doNotUse = false;

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
        if (this.block != null) {
            if (this.storedRequirements.length != 0) {
                Collections.addAll(requirements, this.storedRequirements);
            } else {
                requirements.add(new ItemStack(this.block, 1, this.meta));
            }
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return this.block == context.world().getBlock(x, y, z) && this.meta == context.world().getBlockMetadata(x, y, z);
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        this.setBlockInWorld(context, x, y, z);
    }

    @Override
    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        ArrayList req;
        super.storeRequirements(context, x, y, z);
        if (this.block != null && (req = this.block.getDrops(context.world(), x, y, z, context.world().getBlockMetadata(x, y, z), 0)) != null) {
            this.storedRequirements = new ItemStack[req.size()];
            req.toArray(this.storedRequirements);
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        this.writeBlockToNBT(nbt, registry);
        this.writeRequirementsToNBT(nbt, registry);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.readBlockFromNBT(nbt, registry);
        if (!this.doNotUse()) {
            this.readRequirementsFromNBT(nbt, registry);
        }
    }

    public Set<BlockIndex> getPrerequisiteBlocks(IBuilderContext context) {
        HashSet<BlockIndex> indexes = new HashSet<BlockIndex>();
        if (this.block instanceof BlockFalling) {
            indexes.add(RELATIVE_INDEXES[ForgeDirection.DOWN.ordinal()]);
        }
        return indexes;
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        if (this.block instanceof BlockFluidBase || this.block instanceof BlockLiquid) {
            return Schematic.BuildingStage.EXPANDING;
        }
        return Schematic.BuildingStage.STANDALONE;
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.defaultPermission;
    }

    protected void setBlockInWorld(IBuilderContext context, int x, int y, int z) {
        context.world().setBlock(x, y, z, this.block, this.meta, 3);
        context.world().setBlockMetadataWithNotify(x, y, z, this.meta, 3);
    }

    @Override
    public boolean doNotUse() {
        return this.doNotUse;
    }

    protected void readBlockFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        try {
            this.block = registry.getBlockForId(nbt.getInteger("blockId"));
            this.meta = nbt.getInteger("blockMeta");
        }
        catch (MappingNotFoundException e) {
            this.doNotUse = true;
        }
    }

    protected void readRequirementsFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        if (nbt.hasKey("rq")) {
            NBTTagList rq = nbt.getTagList("rq", 10);
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < rq.tagCount(); ++i) {
                try {
                    NBTTagCompound sub = rq.getCompoundTagAt(i);
                    if (sub.getInteger("id") >= 0) {
                        registry.stackToWorld(sub);
                        rqs.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)sub));
                        continue;
                    }
                    this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                    continue;
                }
                catch (MappingNotFoundException e) {
                    this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                }
            }
            this.storedRequirements = rqs.toArray(new ItemStack[rqs.size()]);
        } else {
            this.storedRequirements = new ItemStack[0];
        }
    }

    protected void writeBlockToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.setInteger("blockId", registry.getIdForBlock(this.block));
        nbt.setInteger("blockMeta", this.meta);
    }

    protected void writeRequirementsToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        if (this.storedRequirements.length > 0) {
            NBTTagList rq = new NBTTagList();
            for (ItemStack stack : this.storedRequirements) {
                NBTTagCompound sub = new NBTTagCompound();
                stack.writeToNBT(sub);
                registry.stackToRegistry(sub);
                rq.appendTag((NBTBase)sub);
            }
            nbt.setTag("rq", (NBTBase)rq);
        }
    }
}

