/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.tools.IToolWrench;
import buildcraft.builders.TileQuarry;
import buildcraft.core.BlockHatched;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockQuarry
extends BlockHatched {
    public BlockQuarry() {
        super(Material.iron);
        this.setHardness(10.0f);
        this.setResistance(10.0f);
        this.setStepSound(soundTypeAnvil);
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile;
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        if (entityliving instanceof EntityPlayer && (tile = world.getTileEntity(i, j, k)) instanceof TileQuarry) {
            ((TileQuarry)tile).placedBy = (EntityPlayer)entityliving;
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileQuarry();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (BuildCraftBuilders.quarryOneTimeUse) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    @Override
    public void breakBlock(World world, int i, int j, int k, Block block, int metadata) {
        if (world.isRemote) {
            return;
        }
        BuildCraftBuilders.frameBlock.removeNeighboringFrames(world, i, j, k);
        super.breakBlock(world, i, j, k, block, metadata);
    }

    @Override
    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        Item equipped;
        if (super.onBlockActivated(world, i, j, k, entityplayer, par6, par7, par8, par9)) {
            return true;
        }
        TileQuarry tile = (TileQuarry)world.getTileEntity(i, j, k);
        if (entityplayer.isSneaking()) {
            return false;
        }
        Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
        if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, i, j, k)) {
            tile.reinitalize();
            ((IToolWrench)equipped).wrenchUsed(entityplayer, i, j, k);
            return true;
        }
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }
}

