/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.builders.blueprints.RecursiveBlueprintBuilder;
import buildcraft.core.Box;
import buildcraft.core.LaserData;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankManager;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBuilder
extends TileAbstractBuilder
implements IHasWork,
IFluidHandler,
IRequestProvider,
IControllable {
    private static int POWER_ACTIVATION = 500;
    public Box box = new Box();
    public PathIterator currentPathIterator;
    public Tank[] fluidTanks = new Tank[]{new Tank("fluid1", 8000, this), new Tank("fluid2", 8000, this), new Tank("fluid3", 8000, this), new Tank("fluid4", 8000, this)};
    public TankManager<Tank> fluidTank = new TankManager(this.fluidTanks);
    private SafeTimeTracker networkUpdateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor / 2);
    private boolean shouldUpdateRequirements;
    private SimpleInventory inv = new SimpleInventory(28, "Builder", 64);
    private BptBuilderBase currentBuilder;
    private RecursiveBlueprintBuilder recursiveBuilder;
    private List<BlockIndex> path;
    private ArrayList<RequirementItemStack> requiredToBuild;
    private NBTTagCompound initNBT = null;
    private boolean done = true;
    private boolean isBuilding = false;

    public TileBuilder() {
        this.box.kind = Box.Kind.STRIPES;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.initNBT != null) {
            this.iterateBpt(true);
            if (this.initNBT.hasKey("iterator")) {
                BlockIndex bi;
                BlockIndex expectedTo = new BlockIndex(this.initNBT.getCompoundTag("iterator"));
                while (!this.done && this.currentBuilder != null && this.currentPathIterator != null && !(bi = new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz)).equals(expectedTo)) {
                    this.iterateBpt(true);
                }
            }
            if (this.currentBuilder != null) {
                this.currentBuilder.loadBuildStateToNBT(this.initNBT.getCompoundTag("builderState"), this);
            }
            this.initNBT = null;
        }
        this.box.kind = Box.Kind.STRIPES;
        for (int x = this.xCoord - 1; x <= this.xCoord + 1; ++x) {
            block2: for (int y = this.yCoord - 1; y <= this.yCoord + 1; ++y) {
                for (int z = this.zCoord - 1; z <= this.zCoord + 1; ++z) {
                    TileEntity tile = this.worldObj.getTileEntity(x, y, z);
                    if (!(tile instanceof IPathProvider)) continue;
                    this.path = ((IPathProvider)tile).getPath();
                    ((IPathProvider)tile).removeFromWorld();
                    continue block2;
                }
            }
        }
        if (this.path != null && this.pathLasers.size() == 0) {
            this.createLasersForPath();
            this.sendNetworkUpdate();
        }
        this.iterateBpt(false);
    }

    public void createLasersForPath() {
        this.pathLasers = new LinkedList();
        BlockIndex previous = null;
        for (BlockIndex b : this.path) {
            if (previous != null) {
                LaserData laser = new LaserData(new Position((double)previous.x + 0.5, (double)previous.y + 0.5, (double)previous.z + 0.5), new Position((double)b.x + 0.5, (double)b.y + 0.5, (double)b.z + 0.5));
                this.pathLasers.add(laser);
            }
            previous = b;
        }
    }

    public BlueprintBase instanciateBlueprint() {
        BlueprintBase bpt;
        try {
            bpt = ItemBlueprint.loadBlueprint(this.getStackInSlot(0));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return bpt;
    }

    @Deprecated
    public BptBuilderBase instanciateBluePrintBuilder(int x, int y, int z, ForgeDirection o) {
        BlueprintBase bpt = this.instanciateBlueprint();
        if (bpt == null) {
            return null;
        }
        if ((bpt = bpt.adjustToWorld(this.worldObj, x, y, z, o)) != null) {
            if (this.getStackInSlot(0).getItem() instanceof ItemBlueprintStandard) {
                return new BptBuilderBlueprint((Blueprint)bpt, this.worldObj, x, y, z);
            }
            if (this.getStackInSlot(0).getItem() instanceof ItemBlueprintTemplate) {
                return new BptBuilderTemplate(bpt, this.worldObj, x, y, z);
            }
        }
        return null;
    }

    public void iterateBpt(boolean forceIterate) {
        if ((this.getStackInSlot(0) == null || !(this.getStackInSlot(0).getItem() instanceof ItemBlueprint)) && this.box.isInitialized()) {
            if (this.currentBuilder != null) {
                this.currentBuilder = null;
            }
            if (this.box.isInitialized()) {
                this.box.reset();
            }
            if (this.currentPathIterator != null) {
                this.currentPathIterator = null;
            }
            this.scheduleRequirementUpdate();
            this.sendNetworkUpdate();
            return;
        }
        if (this.currentBuilder == null || this.currentBuilder.isDone(this) || forceIterate) {
            if (this.path != null && this.path.size() > 1) {
                if (this.currentPathIterator == null) {
                    Iterator<BlockIndex> it = this.path.iterator();
                    BlockIndex start = it.next();
                    this.currentPathIterator = new PathIterator(start, it, ForgeDirection.values()[this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord)].getOpposite());
                }
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.worldObj);
                }
                this.currentBuilder = this.currentPathIterator.next();
                if (this.currentBuilder != null) {
                    this.box.reset();
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                }
                if (this.currentBuilder == null) {
                    this.currentPathIterator = this.currentPathIterator.iterate();
                }
                this.done = this.currentPathIterator == null;
                this.scheduleRequirementUpdate();
            } else {
                if (this.currentBuilder != null && this.currentBuilder.isDone(this)) {
                    this.currentBuilder.postProcessing(this.worldObj);
                    this.currentBuilder = this.recursiveBuilder.nextBuilder();
                    this.scheduleRequirementUpdate();
                } else {
                    BlueprintBase bpt = this.instanciateBlueprint();
                    if (bpt != null) {
                        this.recursiveBuilder = new RecursiveBlueprintBuilder(bpt, this.worldObj, this.xCoord, this.yCoord, this.zCoord, ForgeDirection.values()[this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord)].getOpposite());
                        this.currentBuilder = this.recursiveBuilder.nextBuilder();
                        this.scheduleRequirementUpdate();
                    }
                }
                if (this.currentBuilder == null) {
                    this.done = true;
                } else {
                    this.box.initialize(this.currentBuilder);
                    this.sendNetworkUpdate();
                    this.done = false;
                }
            }
        }
        if (this.done && this.getStackInSlot(0) != null) {
            boolean dropBlueprint = true;
            for (int i = 1; i < this.getSizeInventory(); ++i) {
                if (this.getStackInSlot(i) != null) continue;
                this.setInventorySlotContents(i, this.getStackInSlot(0));
                dropBlueprint = false;
                break;
            }
            if (dropBlueprint) {
                InvUtils.dropItems(this.getWorldObj(), this.getStackInSlot(0), this.xCoord, this.yCoord, this.zCoord);
            }
            this.setInventorySlotContents(0, null);
            this.box.reset();
        }
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int i) {
        return this.inv.getStackInSlot(i);
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack result = this.inv.decrStackSize(i, j);
        if (!this.worldObj.isRemote && i == 0) {
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clearItemRequirements", null), this.worldObj);
            this.iterateBpt(false);
        }
        return result;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        this.inv.setInventorySlotContents(i, itemstack);
        if (!this.worldObj.isRemote && i == 0) {
            this.iterateBpt(false);
            this.done = false;
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "Builder";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("box")) {
            this.box.initialize(nbttagcompound.getCompoundTag("box"));
        }
        if (nbttagcompound.hasKey("path")) {
            this.path = new LinkedList<BlockIndex>();
            NBTTagList list = nbttagcompound.getTagList("path", 10);
            for (int i = 0; i < list.tagCount(); ++i) {
                this.path.add(new BlockIndex(list.getCompoundTagAt(i)));
            }
        }
        this.done = nbttagcompound.getBoolean("done");
        this.fluidTank.readFromNBT(nbttagcompound);
        this.initNBT = (NBTTagCompound)nbttagcompound.getCompoundTag("bptBuilder").copy();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
        if (this.box.isInitialized()) {
            NBTTagCompound boxStore = new NBTTagCompound();
            this.box.writeToNBT(boxStore);
            nbttagcompound.setTag("box", (NBTBase)boxStore);
        }
        if (this.path != null) {
            NBTTagList list = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound c = new NBTTagCompound();
                i.writeTo(c);
                list.appendTag((NBTBase)c);
            }
            nbttagcompound.setTag("path", (NBTBase)list);
        }
        nbttagcompound.setBoolean("done", this.done);
        this.fluidTank.writeToNBT(nbttagcompound);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentBuilder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentBuilder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.setTag("builderState", (NBTBase)builderCpt);
        }
        if (this.currentPathIterator != null) {
            NBTTagCompound iteratorNBT = new NBTTagCompound();
            new BlockIndex((int)this.currentPathIterator.ix, (int)this.currentPathIterator.iy, (int)this.currentPathIterator.iz).writeTo(iteratorNBT);
            bptNBT.setTag("iterator", (NBTBase)iteratorNBT);
        }
        nbttagcompound.setTag("bptBuilder", (NBTBase)bptNBT);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.destroy();
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.shouldUpdateRequirements && this.networkUpdateTracker.markTimeIfDelay(this.worldObj)) {
            this.updateRequirements();
            this.shouldUpdateRequirements = false;
        }
        if ((this.currentBuilder == null || this.currentBuilder.isDone(this)) && this.box.isInitialized()) {
            this.box.reset();
            this.sendNetworkUpdate();
            return;
        }
        this.iterateBpt(false);
        if (this.mode != IControllable.Mode.Off && (this.getWorldObj().getWorldInfo().getGameType() == WorldSettings.GameType.CREATIVE || this.getBattery().getEnergyStored() > POWER_ACTIVATION)) {
            this.build();
        }
        if (!this.isBuilding && this.isBuildingBlueprint()) {
            this.scheduleRequirementUpdate();
        }
        this.isBuilding = this.isBuildingBlueprint();
        if (this.done) {
            return;
        }
        if (this.getBattery().getEnergyStored() < 25) {
            return;
        }
    }

    @Override
    public boolean hasWork() {
        return !this.done;
    }

    public boolean isBuildingBlueprint() {
        return this.getStackInSlot(0) != null && this.getStackInSlot(0).getItem() instanceof ItemBlueprint;
    }

    public List<RequirementItemStack> getNeededItems() {
        return this.worldObj.isRemote ? this.requiredToBuild : (this.currentBuilder instanceof BptBuilderBlueprint ? ((BptBuilderBlueprint)this.currentBuilder).getNeededItems() : null);
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isClient()) {
            if ("clearItemRequirements".equals(command)) {
                this.requiredToBuild = null;
            } else if ("setItemRequirements".equals(command)) {
                int size = stream.readUnsignedMedium();
                this.requiredToBuild = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    int itemId = stream.readUnsignedShort();
                    short itemDamage = stream.readShort();
                    int stackSize = stream.readUnsignedMedium();
                    boolean hasCompound = stackSize >= 0x800000;
                    ItemStack stack = new ItemStack(Item.getItemById((int)itemId), 1, (int)itemDamage);
                    if (hasCompound) {
                        stack.setTagCompound(NetworkUtils.readNBT(stream));
                    }
                    if (stack.getItem() != null) {
                        this.requiredToBuild.add(new RequirementItemStack(stack, stackSize & 0x7FFFFF));
                        continue;
                    }
                    BCLog.logger.error("Corrupt ItemStack in TileBuilder.receiveCommand! This should not happen! (ID " + itemId + ", damage " + itemDamage + ")");
                }
            }
        } else if (side.isServer()) {
            EntityPlayer player = (EntityPlayer)sender;
            if ("eraseFluidTank".equals(command)) {
                int id = stream.readInt();
                if (id < 0 || id >= this.fluidTanks.length) {
                    return;
                }
                if (this.isUseableByPlayer(player) && player.getDistanceSq((double)this.xCoord, (double)this.yCoord, (double)this.zCoord) <= 64.0) {
                    this.fluidTanks[id].setFluid(null);
                    this.sendNetworkUpdate();
                }
            }
        }
    }

    private Packet getItemRequirementsPacket(List<RequirementItemStack> itemsIn) {
        if (itemsIn != null) {
            final ArrayList<RequirementItemStack> items = new ArrayList<RequirementItemStack>();
            items.addAll(itemsIn);
            return new PacketCommand(this, "setItemRequirements", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeMedium(items.size());
                    for (RequirementItemStack rb : items) {
                        data.writeShort(Item.getIdFromItem((Item)rb.stack.getItem()));
                        data.writeShort(rb.stack.getItemDamage());
                        data.writeMedium((rb.stack.hasTagCompound() ? 0x800000 : 0) | Math.min(0x7FFFFF, rb.size));
                        if (!rb.stack.hasTagCompound()) continue;
                        NetworkUtils.writeNBT(data, rb.stack.getTagCompound());
                    }
                }
            });
        }
        return new PacketCommand(this, "clearItemRequirements", null);
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return i != 0;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.getItem() instanceof ItemBlueprint;
        }
        return true;
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        Box renderBox = new Box(this).extendToEncompass(this.box);
        for (LaserData l : this.pathLasers) {
            renderBox = renderBox.extendToEncompass(l.head);
            renderBox = renderBox.extendToEncompass(l.tail);
        }
        return renderBox.expand(50).getBoundingBox();
    }

    public void build() {
        if (this.currentBuilder != null && this.currentBuilder.buildNextSlot(this.worldObj, this, this.xCoord, this.yCoord, this.zCoord)) {
            this.scheduleRequirementUpdate();
        }
    }

    private void updateRequirements() {
        List<RequirementItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).getNeededItems();
        }
        for (EntityPlayer p : this.guiWatchers) {
            BuildCraftCore.instance.sendToPlayer(p, this.getItemRequirementsPacket(reqCopy));
        }
    }

    public void scheduleRequirementUpdate() {
        this.shouldUpdateRequirements = true;
    }

    public void updateRequirementsOnGuiOpen(EntityPlayer caller) {
        List<RequirementItemStack> reqCopy = null;
        if (this.currentBuilder instanceof BptBuilderBlueprint) {
            this.currentBuilder.initialize();
            reqCopy = ((BptBuilderBlueprint)this.currentBuilder).getNeededItems();
        }
        BuildCraftCore.instance.sendToPlayer(caller, this.getItemRequirementsPacket(reqCopy));
    }

    public BptBuilderBase getBlueprint() {
        if (this.currentBuilder != null) {
            return this.currentBuilder;
        }
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean drainBuild(FluidStack fluidStack, boolean realDrain) {
        for (Tank tank : this.fluidTanks) {
            if (tank.getFluidType() != fluidStack.getFluid()) continue;
            return tank.getFluidAmount() >= fluidStack.amount && tank.drain((int)fluidStack.amount, (boolean)realDrain).amount > 0;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid fluid = resource.getFluid();
        Tank emptyTank = null;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                int used = tank.fill(resource, doFill);
                if (used > 0 && doFill) {
                    this.sendNetworkUpdate();
                }
                return used;
            }
            if (emptyTank != null || !tank.isEmpty()) continue;
            emptyTank = tank;
        }
        if (emptyTank != null) {
            int used = emptyTank.fill(resource, doFill);
            if (used > 0 && doFill) {
                this.sendNetworkUpdate();
            }
            return used;
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        boolean emptyAvailable = false;
        for (Tank tank : this.fluidTanks) {
            Fluid type = tank.getFluidType();
            if (type == fluid) {
                return !tank.isFull();
            }
            if (emptyAvailable) continue;
            emptyAvailable = tank.isEmpty();
        }
        return emptyAvailable;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.fluidTank.getTankInfo(from);
    }

    @Override
    public int getRequestsCount() {
        if (this.currentBuilder == null) {
            return 0;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return 0;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        return bpt.getNeededItems().size();
    }

    @Override
    public ItemStack getRequest(int slot) {
        if (this.currentBuilder == null) {
            return null;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return null;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        List<RequirementItemStack> neededItems = bpt.getNeededItems();
        if (neededItems.size() <= slot) {
            return null;
        }
        RequirementItemStack requirement = neededItems.get(slot);
        int qty = this.quantityMissing(requirement.stack, requirement.size);
        if (qty <= 0) {
            return null;
        }
        ItemStack requestStack = requirement.stack.copy();
        requestStack.stackSize = qty;
        return requestStack;
    }

    @Override
    public ItemStack offerItem(int slot, ItemStack stack) {
        if (this.currentBuilder == null) {
            return stack;
        }
        if (!(this.currentBuilder instanceof BptBuilderBlueprint)) {
            return stack;
        }
        BptBuilderBlueprint bpt = (BptBuilderBlueprint)this.currentBuilder;
        List<RequirementItemStack> neededItems = bpt.getNeededItems();
        if (neededItems.size() <= slot) {
            return stack;
        }
        RequirementItemStack requirement = neededItems.get(slot);
        int qty = this.quantityMissing(requirement.stack, requirement.size);
        if (qty <= 0) {
            return stack;
        }
        ItemStack toAdd = stack.copy();
        if (qty < toAdd.stackSize) {
            toAdd.stackSize = qty;
        }
        ITransactor t = Transactor.getTransactorFor(this);
        ItemStack added = t.add(toAdd, ForgeDirection.UNKNOWN, true);
        if (added.stackSize >= stack.stackSize) {
            return null;
        }
        stack.stackSize -= added.stackSize;
        return stack;
    }

    private int quantityMissing(ItemStack requirement, int amount) {
        int left = amount <= 0 ? requirement.stackSize : amount;
        for (IInvSlot slot : InventoryIterator.getIterable(this)) {
            if (slot.getStackInSlot() == null || !StackHelper.isEqualItem(requirement, slot.getStackInSlot())) continue;
            if (slot.getStackInSlot().stackSize >= left) {
                return 0;
            }
            left -= slot.getStackInSlot().stackSize;
        }
        return left;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        this.fluidTank.writeData(stream);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        this.fluidTank.readData(stream);
    }

    @Override
    public Tank[] getFluidTanks() {
        return this.fluidTanks;
    }

    private class PathIterator {
        public Iterator<BlockIndex> currentIterator;
        public double cx;
        public double cy;
        public double cz;
        public float ix;
        public float iy;
        public float iz;
        public BlockIndex to;
        public double lastDistance;
        AxisAlignedBB oldBoundingBox = null;
        ForgeDirection o = null;

        public PathIterator(BlockIndex from, Iterator<BlockIndex> it, ForgeDirection initialDir) {
            this.to = it.next();
            this.currentIterator = it;
            double dx = this.to.x - from.x;
            double dy = this.to.y - from.y;
            double dz = this.to.z - from.z;
            double size = Math.sqrt(dx * dx + dy * dy + dz * dz);
            this.cx = dx / size / 10.0;
            this.cy = dy / size / 10.0;
            this.cz = dz / size / 10.0;
            this.ix = from.x;
            this.iy = from.y;
            this.iz = from.z;
            this.lastDistance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
            this.o = dx == 0.0 && dz == 0.0 ? initialDir : (Math.abs(dx) > Math.abs(dz) ? (dx > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST) : (dz > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH));
        }

        public BptBuilderBase next() {
            int newZ;
            int newY;
            int newX;
            BptBuilderBase bpt;
            while ((bpt = TileBuilder.this.instanciateBluePrintBuilder(newX = Math.round(this.ix), newY = Math.round(this.iy), newZ = Math.round(this.iz), this.o)) != null) {
                AxisAlignedBB boundingBox = bpt.getBoundingBox();
                if (this.oldBoundingBox == null || !this.collision(this.oldBoundingBox, boundingBox)) {
                    this.oldBoundingBox = boundingBox;
                    return bpt;
                }
                this.ix = (float)((double)this.ix + this.cx);
                this.iy = (float)((double)this.iy + this.cy);
                this.iz = (float)((double)this.iz + this.cz);
                double distance = (this.ix - (float)this.to.x) * (this.ix - (float)this.to.x) + (this.iy - (float)this.to.y) * (this.iy - (float)this.to.y) + (this.iz - (float)this.to.z) * (this.iz - (float)this.to.z);
                if (distance > this.lastDistance) {
                    return null;
                }
                this.lastDistance = distance;
            }
            return null;
        }

        public PathIterator iterate() {
            if (this.currentIterator.hasNext()) {
                PathIterator next = new PathIterator(this.to, this.currentIterator, this.o);
                next.oldBoundingBox = this.oldBoundingBox;
                return next;
            }
            return null;
        }

        public boolean collision(AxisAlignedBB left, AxisAlignedBB right) {
            if (left.maxX < right.minX || left.minX > right.maxX) {
                return false;
            }
            if (left.maxY < right.minY || left.minY > right.maxY) {
                return false;
            }
            return !(left.maxZ < right.minZ) && !(left.minZ > right.maxZ);
        }
    }
}

