/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.builders.TileArchitect;
import buildcraft.builders.gui.SlotArchitect;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerArchitect
extends BuildCraftContainer {
    protected IInventory playerIInventory;
    protected TileArchitect architect;
    protected int computingTime = 0;

    public ContainerArchitect(EntityPlayer player, TileArchitect template) {
        super(template.getSizeInventory());
        this.playerIInventory = player.inventory;
        this.architect = template;
        this.addSlotToContainer(new SlotArchitect(template, player, 0, 135, 35));
        this.addSlotToContainer(new SlotOutput(template, 1, 194, 35));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, k1 + l * 9 + 9, 88 + k1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot((IInventory)player.inventory, i1, 88 + i1 * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.architect.getComputingProgressScaled(24));
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (Object crafter : this.crafters) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.computingTime == this.architect.getComputingProgressScaled(24)) continue;
            icrafting.sendProgressBarUpdate((Container)this, 0, this.architect.getComputingProgressScaled(24));
        }
        this.computingTime = this.architect.getComputingProgressScaled(24);
    }

    public void updateProgressBar(int i, int j) {
        if (i == 0) {
            this.computingTime = j;
        }
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.architect.isUseableByPlayer(entityplayer);
    }
}

