/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.api.library.LibraryAPI;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.builders.gui.ContainerBlueprintLibrary;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.StringUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBlueprintLibrary
extends GuiBuildCraft {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/library_rw.png");
    private GuiButton deleteButton;
    private TileBlueprintLibrary library;

    public GuiBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(new ContainerBlueprintLibrary(player, library), library, TEXTURE);
        this.xSize = 244;
        this.ySize = 220;
        this.library = library;
    }

    public void initGui() {
        super.initGui();
        this.deleteButton = new GuiButton(2, this.guiLeft + 174, this.guiTop + 109, 25, 20, StringUtils.localize("gui.del"));
        this.buttonList.add(this.deleteButton);
        this.library.refresh();
        this.checkDelete();
    }

    private ContainerBlueprintLibrary getLibraryContainer() {
        return (ContainerBlueprintLibrary)this.getContainer();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        int off;
        String title = StringUtils.localize("tile.libraryBlock.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        for (int i = off = this.getLibraryContainer().scrollbarWidget.getPosition(); i < off + 12 && i < this.library.entries.size(); ++i) {
            LibraryId bpt = this.library.entries.get(i);
            String name = bpt.name;
            if (name.length() > 32) {
                name = name.substring(0, 32);
            }
            if (i == this.library.selected) {
                int l1 = 8;
                int i2 = 22;
                this.drawGradientRect(l1, i2 + 9 * (i - off), l1 + 146, i2 + 9 * (i - off + 1), -2130706433, -2130706433);
            }
            while (this.fontRendererObj.getStringWidth(name) > 151) {
                name = name.substring(0, name.length() - 1);
            }
            this.fontRendererObj.drawString(name, 9, 23 + 9 * (i - off), LibraryAPI.getHandlerFor(bpt.extension).getTextColor());
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.getLibraryContainer().scrollbarWidget.hidden = this.library.entries.size() <= 12;
        this.getLibraryContainer().scrollbarWidget.setLength(Math.max(0, this.library.entries.size() - 12));
        this.drawWidgets(x, y);
        int inP = this.library.progressIn * 22 / 100;
        int outP = this.library.progressOut * 22 / 100;
        this.drawTexturedModalRect(this.guiLeft + 194 + 22 - inP, this.guiTop + 57, 256 - inP, 240, inP, 16);
        this.drawTexturedModalRect(this.guiLeft + 194, this.guiTop + 79, 234, 224, outP, 16);
    }

    protected void actionPerformed(GuiButton button) {
        if (this.deleteButton != null && button == this.deleteButton) {
            this.library.deleteSelectedBpt();
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        int ySlot;
        super.mouseClicked(i, j, k);
        int x = i - this.guiLeft;
        int y = j - this.guiTop;
        if (x >= 8 && x <= 161 && (ySlot = (y - 22) / 9 + this.getLibraryContainer().scrollbarWidget.getPosition()) > -1 && ySlot < this.library.entries.size()) {
            this.library.selectBlueprint(ySlot);
        }
        this.checkDelete();
    }

    protected void checkDelete() {
        this.deleteButton.enabled = this.library.selected != -1;
    }
}

