/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.IZone;
import buildcraft.api.items.IMapLocation;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.Box;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.robotics.ZonePlan;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemMapLocation
extends ItemBuildCraft
implements IMapLocation {
    public ItemMapLocation() {
        super(BCCreativeTab.get("main"));
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).hasKey("kind") ? 1 : 16;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        String name;
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (cpt.hasKey("name") && (name = cpt.getString("name")).length() > 0) {
            list.add(name);
        }
        if (cpt.hasKey("kind")) {
            switch (cpt.getByte("kind")) {
                case 0: {
                    int x = cpt.getInteger("x");
                    int y = cpt.getInteger("y");
                    int z = cpt.getInteger("z");
                    ForgeDirection side = ForgeDirection.values()[cpt.getByte("side")];
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + ", " + side + "}"));
                    break;
                }
                case 1: {
                    int x = cpt.getInteger("xMin");
                    int y = cpt.getInteger("yMin");
                    int z = cpt.getInteger("zMin");
                    int xLength = cpt.getInteger("xMax") - x + 1;
                    int yLength = cpt.getInteger("yMax") - y + 1;
                    int zLength = cpt.getInteger("zMax") - z + 1;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + {" + xLength + " x " + yLength + " x " + zLength + "}"));
                    break;
                }
                case 2: {
                    NBTTagList pathNBT = cpt.getTagList("path", 10);
                    BlockIndex first = new BlockIndex(pathNBT.getCompoundTagAt(0));
                    int x = first.x;
                    int y = first.y;
                    int z = first.z;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + " + pathNBT.tagCount() + " elements"));
                    break;
                }
            }
        }
    }

    public IIcon getIconIndex(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (!cpt.hasKey("kind")) {
            return this.icons[0];
        }
        return this.getIconFromDamage(cpt.getByte("kind") + 1);
    }

    @Override
    public String[] getIconNames() {
        return new String[]{"mapLocation/clean", "mapLocation/spot", "mapLocation/area", "mapLocation/path", "mapLocation/zone"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        super.registerIcons(par1IconRegister);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer par2EntityPlayer, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity tile = world.getTileEntity(x, y, z);
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (tile instanceof IPathProvider) {
            cpt.setByte("kind", (byte)2);
            NBTTagList pathNBT = new NBTTagList();
            for (BlockIndex index : ((IPathProvider)tile).getPath()) {
                NBTTagCompound nbt = new NBTTagCompound();
                index.writeTo(nbt);
                pathNBT.appendTag((NBTBase)nbt);
            }
            cpt.setTag("path", (NBTBase)pathNBT);
        } else if (tile instanceof IAreaProvider) {
            cpt.setByte("kind", (byte)1);
            IAreaProvider areaTile = (IAreaProvider)tile;
            cpt.setInteger("xMin", areaTile.xMin());
            cpt.setInteger("yMin", areaTile.yMin());
            cpt.setInteger("zMin", areaTile.zMin());
            cpt.setInteger("xMax", areaTile.xMax());
            cpt.setInteger("yMax", areaTile.yMax());
            cpt.setInteger("zMax", areaTile.zMax());
        } else {
            cpt.setByte("kind", (byte)0);
            cpt.setByte("side", (byte)side);
            cpt.setInteger("x", x);
            cpt.setInteger("y", y);
            cpt.setInteger("z", z);
        }
        return true;
    }

    @Override
    public IBox getBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 1) {
            int xMin = cpt.getInteger("xMin");
            int yMin = cpt.getInteger("yMin");
            int zMin = cpt.getInteger("zMin");
            int xMax = cpt.getInteger("xMax");
            int yMax = cpt.getInteger("yMax");
            int zMax = cpt.getInteger("zMax");
            return new Box(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    public static IBox getPointBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            int x = cpt.getInteger("x");
            int y = cpt.getInteger("y");
            int z = cpt.getInteger("z");
            return new Box(x, y, z, x, y, z);
        }
        return null;
    }

    @Override
    public ForgeDirection getPointSide(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ForgeDirection.values()[cpt.getByte("side")];
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public BlockIndex getPoint(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return new BlockIndex(cpt.getInteger("x"), cpt.getInteger("y"), cpt.getInteger("z"));
        }
        return null;
    }

    @Override
    public IZone getZone(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 3) {
            ZonePlan plan = new ZonePlan();
            plan.readFromNBT(cpt);
            return plan;
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 1) {
            return this.getBox(item);
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    @Override
    public List<BlockIndex> getPath(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 2) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            NBTTagList pathNBT = cpt.getTagList("path", 10);
            for (int i = 0; i < pathNBT.tagCount(); ++i) {
                indexList.add(new BlockIndex(pathNBT.getCompoundTagAt(i)));
            }
            return indexList;
        }
        if (cpt.hasKey("kind") && cpt.getByte("kind") == 0) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            indexList.add(new BlockIndex(cpt.getInteger("x"), cpt.getInteger("y"), cpt.getInteger("z")));
            return indexList;
        }
        return null;
    }

    public static void setZone(ItemStack item, ZonePlan plan) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.setByte("kind", (byte)3);
        plan.writeToNBT(cpt);
    }

    @Override
    public String getName(ItemStack item) {
        return NBTUtils.getItemData(item).getString("name");
    }

    @Override
    public boolean setName(ItemStack item, String name) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.setString("name", name);
        return true;
    }

    @Override
    public IMapLocation.MapLocationType getType(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        return IMapLocation.MapLocationType.values()[cpt.getByte("kind")];
    }
}

