/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.blocks.IColorRemovable;
import buildcraft.api.core.EnumColor;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPaintbrush
extends ItemBuildCraft {
    public ItemPaintbrush() {
        this.setFull3D();
        this.setMaxStackSize(1);
        this.setMaxDamage(63);
    }

    private int getColor(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            return -1;
        }
        NBTTagCompound compound = NBTUtils.getItemData(stack);
        return compound.hasKey("color") ? (int)compound.getByte("color") : -1;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > this.getMaxDamage()) {
            stack.setTagCompound(null);
            super.setDamage(stack, 0);
        } else {
            super.setDamage(stack, damage);
        }
    }

    @Override
    public String[] getIconNames() {
        String[] names = new String[17];
        names[0] = "paintbrush/clean";
        for (int i = 0; i < 16; ++i) {
            names[1 + i] = "paintbrush/" + EnumColor.fromId(i).name().toLowerCase(Locale.ENGLISH);
        }
        return names;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        super.registerIcons(par1IconRegister);
        IIcon[] brushColors = new IIcon[16];
        System.arraycopy(this.icons, 1, brushColors, 0, 16);
        EnumColor.setIconArray(brushColors);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconIndex(ItemStack stack) {
        this.itemIcon = this.icons[(this.getColor(stack) + 1) % this.icons.length];
        return this.itemIcon;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        String base = super.getItemStackDisplayName(stack);
        int dye = this.getColor(stack);
        if (dye >= 0) {
            return base + " (" + EnumColor.fromId(dye).getLocalizedName() + ")";
        }
        return base;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int dye = this.getColor(stack);
        Block block = world.getBlock(x, y, z);
        if (block == null) {
            return false;
        }
        if (dye >= 0) {
            if (block.recolourBlock(world, x, y, z, ForgeDirection.getOrientation((int)side), 15 - dye)) {
                player.swingItem();
                this.setDamage(stack, this.getDamage(stack) + 1);
                return !world.isRemote;
            }
        } else if (block instanceof IColorRemovable && ((IColorRemovable)block).removeColorFromBlock(world, x, y, z, ForgeDirection.getOrientation((int)side))) {
            player.swingItem();
            return !world.isRemote;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        itemList.add(new ItemStack((Item)this));
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = new ItemStack((Item)this);
            NBTUtils.getItemData(stack).setByte("color", (byte)i);
            itemList.add(stack);
        }
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }
}

