/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.Position;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import buildcraft.core.TileMarker;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TilePathMarker
extends TileMarker
implements IPathProvider {
    private static ArrayList<TilePathMarker> availableMarkers = new ArrayList();
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public boolean loadLink0 = false;
    public boolean loadLink1 = false;
    public LaserData[] lasers = new LaserData[2];
    public boolean tryingToConnect = false;
    public TilePathMarker[] links = new TilePathMarker[2];

    public boolean isFullyConnected() {
        return this.lasers[0] != null && this.lasers[1] != null;
    }

    public boolean isLinkedTo(TilePathMarker pathMarker) {
        return this.links[0] == pathMarker || this.links[1] == pathMarker;
    }

    public void connect(TilePathMarker marker, LaserData laser) {
        if (this.lasers[0] == null) {
            this.lasers[0] = laser;
            this.links[0] = marker;
        } else if (this.lasers[1] == null) {
            this.lasers[1] = laser;
            this.links[1] = marker;
        }
        if (this.isFullyConnected()) {
            availableMarkers.remove(this);
        }
    }

    public void createLaserAndConnect(TilePathMarker pathMarker) {
        if (this.worldObj.isRemote) {
            return;
        }
        LaserData laser = new LaserData(new Position((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5), new Position((double)pathMarker.xCoord + 0.5, (double)pathMarker.yCoord + 0.5, (double)pathMarker.zCoord + 0.5));
        LaserData laser2 = new LaserData(laser.head, laser.tail);
        laser2.isVisible = false;
        this.connect(pathMarker, laser);
        pathMarker.connect(this, laser2);
    }

    private TilePathMarker findNearestAvailablePathMarker() {
        TilePathMarker nearestAvailable = null;
        double nearestDistance = 0.0;
        for (TilePathMarker t : availableMarkers) {
            int dz;
            int dy;
            int dx;
            double distance;
            if (t == this || t == this.links[0] || t == this.links[1] || t.getWorldObj().provider.dimensionId != this.getWorldObj().provider.dimensionId || (distance = (double)((dx = this.xCoord - t.xCoord) * dx + (dy = this.yCoord - t.yCoord) * dy + (dz = this.zCoord - t.zCoord) * dz)) > (double)(DefaultProps.MARKER_RANGE * DefaultProps.MARKER_RANGE) || nearestAvailable != null && !(distance < nearestDistance)) continue;
            nearestAvailable = t;
            nearestDistance = distance;
        }
        return nearestAvailable;
    }

    @Override
    public void tryConnection() {
        if (this.worldObj.isRemote || this.isFullyConnected()) {
            return;
        }
        this.tryingToConnect = !this.tryingToConnect;
        this.sendNetworkUpdate();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.tryingToConnect) {
            TilePathMarker nearestPathMarker = this.findNearestAvailablePathMarker();
            if (nearestPathMarker != null) {
                this.createLaserAndConnect(nearestPathMarker);
            }
            this.tryingToConnect = false;
            this.sendNetworkUpdate();
            this.getWorldObj().markBlockRangeForRenderUpdate(this.xCoord, this.yCoord, this.zCoord, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public ArrayList<BlockIndex> getPath() {
        HashSet<BlockIndex> visitedPaths = new HashSet<BlockIndex>();
        ArrayList<BlockIndex> res = new ArrayList<BlockIndex>();
        TilePathMarker nextTile = this;
        while (nextTile != null) {
            BlockIndex b = new BlockIndex(nextTile.xCoord, nextTile.yCoord, nextTile.zCoord);
            visitedPaths.add(b);
            res.add(b);
            if (nextTile.links[0] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[0].xCoord, nextTile.links[0].yCoord, nextTile.links[0].zCoord))) {
                nextTile = nextTile.links[0];
                continue;
            }
            if (nextTile.links[1] != null && !visitedPaths.contains(new BlockIndex(nextTile.links[1].xCoord, nextTile.links[1].yCoord, nextTile.links[1].zCoord))) {
                nextTile = nextTile.links[1];
                continue;
            }
            nextTile = null;
        }
        return res;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.links[0] != null) {
            this.links[0].unlink(this);
        }
        if (this.links[1] != null) {
            this.links[1].unlink(this);
        }
        availableMarkers.remove(this);
        this.tryingToConnect = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.worldObj.isRemote && !this.isFullyConnected()) {
            availableMarkers.add(this);
        }
        if (this.loadLink0) {
            TileEntity e0 = this.worldObj.getTileEntity(this.x0, this.y0, this.z0);
            if (this.links[0] != e0 && this.links[1] != e0 && e0 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e0);
            }
            this.loadLink0 = false;
        }
        if (this.loadLink1) {
            TileEntity e1 = this.worldObj.getTileEntity(this.x1, this.y1, this.z1);
            if (this.links[0] != e1 && this.links[1] != e1 && e1 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e1);
            }
            this.loadLink1 = false;
        }
        this.sendNetworkUpdate();
    }

    private void unlink(TilePathMarker tile) {
        if (this.links[0] == tile) {
            this.lasers[0] = null;
            this.links[0] = null;
        }
        if (this.links[1] == tile) {
            this.lasers[1] = null;
            this.links[1] = null;
        }
        if (!(this.isFullyConnected() || availableMarkers.contains(this) || this.worldObj.isRemote)) {
            availableMarkers.add(this);
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("x0")) {
            this.x0 = nbttagcompound.getInteger("x0");
            this.y0 = nbttagcompound.getInteger("y0");
            this.z0 = nbttagcompound.getInteger("z0");
            this.loadLink0 = true;
        }
        if (nbttagcompound.hasKey("x1")) {
            this.x1 = nbttagcompound.getInteger("x1");
            this.y1 = nbttagcompound.getInteger("y1");
            this.z1 = nbttagcompound.getInteger("z1");
            this.loadLink1 = true;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.links[0] != null) {
            nbttagcompound.setInteger("x0", this.links[0].xCoord);
            nbttagcompound.setInteger("y0", this.links[0].yCoord);
            nbttagcompound.setInteger("z0", this.links[0].zCoord);
        }
        if (this.links[1] != null) {
            nbttagcompound.setInteger("x1", this.links[1].xCoord);
            nbttagcompound.setInteger("y1", this.links[1].yCoord);
            nbttagcompound.setInteger("z1", this.links[1].zCoord);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        availableMarkers.remove(this);
    }

    public static void clearAvailableMarkersList() {
        availableMarkers.clear();
    }

    public static void clearAvailableMarkersList(World w) {
        Iterator<TilePathMarker> it = availableMarkers.iterator();
        while (it.hasNext()) {
            TilePathMarker t = it.next();
            if (t.getWorldObj().provider.dimensionId != w.provider.dimensionId) continue;
            it.remove();
        }
    }

    @Override
    public void readData(ByteBuf data) {
        boolean previousState = this.tryingToConnect;
        short flags = data.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.lasers[0] = new LaserData();
            this.lasers[0].readData(data);
        } else {
            this.lasers[0] = null;
        }
        if ((flags & 2) != 0) {
            this.lasers[1] = new LaserData();
            this.lasers[1].readData(data);
        } else {
            this.lasers[1] = null;
        }
        boolean bl = this.tryingToConnect = (flags & 4) != 0;
        if (previousState != this.tryingToConnect) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        int flags = (this.lasers[0] != null ? 1 : 0) | (this.lasers[1] != null ? 2 : 0) | (this.tryingToConnect ? 4 : 0);
        data.writeByte(flags);
        if (this.lasers[0] != null) {
            this.lasers[0].writeData(data);
        }
        if (this.lasers[1] != null) {
            this.lasers[1].writeData(data);
        }
    }

    @Override
    public void removeFromWorld() {
        List path = this.getPath();
        for (BlockIndex b : path) {
            BuildCraftCore.pathMarkerBlock.dropBlockAsItem(this.worldObj, b.x, b.y, b.z, 0, 0);
            this.worldObj.setBlockToAir(b.x, b.y, b.z);
        }
    }
}

