/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.crops;

import buildcraft.api.crops.ICropHandler;
import buildcraft.core.lib.utils.BlockUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class CropHandlerPlantable
implements ICropHandler {
    @Override
    public boolean isSeed(ItemStack stack) {
        Block block;
        if (stack.getItem() instanceof IPlantable) {
            return true;
        }
        return stack.getItem() instanceof ItemBlock && (block = ((ItemBlock)stack.getItem()).field_150939_a) instanceof IPlantable && block != Blocks.reeds;
    }

    @Override
    public boolean canSustainPlant(World world, ItemStack seed, int x, int y, int z) {
        IPlantable plantable;
        if (seed.getItem() instanceof IPlantable) {
            return world.getBlock(x, y, z).canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)seed.getItem()) && world.isAirBlock(x, y + 1, z);
        }
        Block block = world.getBlock(x, y, z);
        return block.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, plantable = (IPlantable)((ItemBlock)seed.getItem()).field_150939_a) && block != ((ItemBlock)seed.getItem()).field_150939_a && world.isAirBlock(x, y + 1, z);
    }

    @Override
    public boolean plantCrop(World world, EntityPlayer player, ItemStack seed, int x, int y, int z) {
        return BlockUtils.useItemOnBlock(world, player, seed, x, y, z, ForgeDirection.UP);
    }

    @Override
    public boolean isMature(IBlockAccess blockAccess, Block block, int meta, int x, int y, int z) {
        if (block == null) {
            return false;
        }
        if (block instanceof BlockTallGrass || block instanceof BlockMelon || block instanceof BlockMushroom || block instanceof BlockDoublePlant || block == Blocks.pumpkin) {
            return true;
        }
        if (block instanceof BlockCrops) {
            return meta == 7;
        }
        if (block instanceof BlockNetherWart) {
            return meta == 3;
        }
        return block instanceof IPlantable && y > 0 && blockAccess.getBlock(x, y - 1, z) == block;
    }

    @Override
    public boolean harvestCrop(World world, int x, int y, int z, List<ItemStack> drops) {
        if (!world.isRemote) {
            Block block = world.getBlock(x, y, z);
            int meta = world.getBlockMetadata(x, y, z);
            if (BlockUtils.breakBlock((WorldServer)world, x, y, z, drops)) {
                world.playAuxSFXAtEntity(null, 2001, x, y, z, Block.getIdFromBlock((Block)block) + (meta << 12));
                return true;
            }
        }
        return false;
    }
}

