/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityBlock
extends Entity {
    @SideOnly(value=Side.CLIENT)
    public IIcon[] texture;
    public float shadowSize = 0.0f;
    public float rotationX = 0.0f;
    public float rotationY = 0.0f;
    public float rotationZ = 0.0f;
    public double iSize;
    public double jSize;
    public double kSize;
    private int brightness = -1;

    public EntityBlock(World world) {
        super(world);
        this.preventEntitySpawning = false;
        this.noClip = true;
        this.isImmuneToFire = true;
    }

    public EntityBlock(World world, double xPos, double yPos, double zPos) {
        super(world);
        this.setPositionAndRotation(xPos, yPos, zPos, 0.0f, 0.0f);
    }

    public EntityBlock(World world, double i, double j, double k, double iSize, double jSize, double kSize) {
        this(world);
        this.iSize = iSize;
        this.jSize = jSize;
        this.kSize = kSize;
        this.setPositionAndRotation(i, j, k, 0.0f, 0.0f);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    public void setTexture(IIcon icon) {
        if (this.texture == null) {
            this.texture = new IIcon[6];
        }
        for (int i = 0; i < 6; ++i) {
            this.texture[i] = icon;
        }
    }

    public void setPosition(double d, double d1, double d2) {
        super.setPosition(d, d1, d2);
        this.boundingBox.minX = this.posX;
        this.boundingBox.minY = this.posY;
        this.boundingBox.minZ = this.posZ;
        this.boundingBox.maxX = this.posX + this.iSize;
        this.boundingBox.maxY = this.posY + this.jSize;
        this.boundingBox.maxZ = this.posZ + this.kSize;
    }

    public void moveEntity(double d, double d1, double d2) {
        this.setPosition(this.posX + d, this.posY + d1, this.posZ + d2);
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        this.iSize = data.getDouble("iSize");
        this.jSize = data.getDouble("jSize");
        this.kSize = data.getDouble("kSize");
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        data.setDouble("iSize", this.iSize);
        data.setDouble("jSize", this.jSize);
        data.setDouble("kSize", this.kSize);
    }

    public int getBrightnessForRender(float par1) {
        return this.brightness > 0 ? this.brightness : super.getBrightnessForRender(par1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distance) {
        return distance < 50000.0;
    }
}

