/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class TileBuffer {
    private Block block = null;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker(20L, 5L);
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final boolean loadUnloaded;

    public TileBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public void refresh() {
        this.tile = null;
        this.block = null;
        if (!this.loadUnloaded && !this.world.blockExists(this.x, this.y, this.z)) {
            return;
        }
        this.block = this.world.getBlock(this.x, this.y, this.z);
        if (this.block != null && this.block.hasTileEntity(BlockUtils.getBlockMetadata(this.world, this.x, this.y, this.z))) {
            this.tile = this.world.getTileEntity(this.x, this.y, this.z);
        }
    }

    public void set(Block block, TileEntity tile) {
        this.block = block;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    private void tryRefresh() {
        if (Utils.CAULDRON_DETECTED || this.tile != null && this.tile.isInvalid() || this.tile == null && this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
        }
    }

    public Block getBlock() {
        this.tryRefresh();
        return this.block;
    }

    public TileEntity getTile() {
        return this.getTile(false);
    }

    public TileEntity getTile(boolean forceUpdate) {
        if (!Utils.CAULDRON_DETECTED && this.tile != null && !this.tile.isInvalid()) {
            return this.tile;
        }
        if (Utils.CAULDRON_DETECTED || forceUpdate && this.tile != null && this.tile.isInvalid() || this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.isInvalid()) {
                return this.tile;
            }
        }
        return null;
    }

    public boolean exists() {
        if (this.tile != null && !Utils.CAULDRON_DETECTED && !this.tile.isInvalid()) {
            return true;
        }
        return this.world.blockExists(this.x, this.y, this.z);
    }

    public static TileBuffer[] makeBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            buffer[i] = new TileBuffer(world, x + d.offsetX, y + d.offsetY, z + d.offsetZ, loadUnloaded);
        }
        return buffer;
    }
}

