/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.commands;

import buildcraft.core.lib.commands.IModCommand;
import buildcraft.core.lib.commands.SubCommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public final class CommandHelpers {
    private CommandHelpers() {
    }

    public static World getWorld(ICommandSender sender, IModCommand command, String[] args, int worldArgIndex) {
        if (worldArgIndex < args.length) {
            try {
                int dim = Integer.parseInt(args[worldArgIndex]);
                WorldServer world = MinecraftServer.getServer().worldServerForDimension(dim);
                if (world != null) {
                    return world;
                }
            }
            catch (Exception ex) {
                CommandHelpers.throwWrongUsage(sender, command);
            }
        }
        return CommandHelpers.getWorld(sender, command);
    }

    public static World getWorld(ICommandSender sender, IModCommand command) {
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            return player.worldObj;
        }
        return MinecraftServer.getServer().worldServerForDimension(0);
    }

    public static String[] getPlayers() {
        return MinecraftServer.getServer().getAllUsernames();
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, String locTag, Object ... args) {
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation(locTag, args));
    }

    public static void sendLocalizedChatMessage(ICommandSender sender, ChatStyle chatStyle, String locTag, Object ... args) {
        ChatComponentTranslation chat = new ChatComponentTranslation(locTag, args);
        chat.setChatStyle(chatStyle);
        sender.addChatMessage((IChatComponent)chat);
    }

    public static void sendChatMessage(ICommandSender sender, String message) {
        sender.addChatMessage((IChatComponent)new ChatComponentText(message));
    }

    public static void throwWrongUsage(ICommandSender sender, IModCommand command) throws WrongUsageException {
        throw new WrongUsageException(String.format(StatCollector.translateToLocal((String)"command.buildcraft.help"), command.getCommandUsage(sender)), new Object[0]);
    }

    public static void processChildCommand(ICommandSender sender, SubCommand child, String[] args) {
        if (!sender.canCommandSenderUseCommand(child.getMinimumPermissionLevel(), child.getFullCommandString())) {
            throw new WrongUsageException(StatCollector.translateToLocal((String)"command.buildcraft.noperms"), new Object[0]);
        }
        String[] newargs = new String[args.length - 1];
        System.arraycopy(args, 1, newargs, 0, newargs.length);
        child.processCommand(sender, newargs);
    }

    public static void printHelp(ICommandSender sender, IModCommand command) {
        ChatStyle header = new ChatStyle();
        header.setColor(EnumChatFormatting.GRAY);
        header.setBold(Boolean.valueOf(true));
        CommandHelpers.sendLocalizedChatMessage(sender, header, "command.buildcraft." + command.getFullCommandString().replace(" ", ".") + ".format", command.getFullCommandString());
        ChatStyle body = new ChatStyle();
        body.setColor(EnumChatFormatting.GRAY);
        if (command.getCommandAliases().size() > 0) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "command.buildcraft.aliases", command.getCommandAliases().toString().replace("[", "").replace("]", ""));
        }
        if (command.getMinimumPermissionLevel() > 0) {
            CommandHelpers.sendLocalizedChatMessage(sender, body, "command.buildcraft.permlevel", command.getMinimumPermissionLevel());
        }
        CommandHelpers.sendLocalizedChatMessage(sender, body, "command.buildcraft." + command.getFullCommandString().replace(" ", ".") + ".help", new Object[0]);
        if (!command.getChildren().isEmpty()) {
            CommandHelpers.sendLocalizedChatMessage(sender, "command.buildcraft.list", new Object[0]);
            for (SubCommand child : command.getChildren()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "command.buildcraft." + child.getFullCommandString().replace(" ", ".") + ".desc", child.getCommandName());
            }
        }
    }

    public static boolean processStandardCommands(ICommandSender sender, IModCommand command, String[] args) {
        if (args.length >= 1) {
            if ("help".equals(args[0])) {
                if (args.length >= 2) {
                    for (SubCommand child : command.getChildren()) {
                        if (!CommandHelpers.matches(args[1], child)) continue;
                        child.printHelp(sender);
                        return true;
                    }
                }
                command.printHelp(sender);
                return true;
            }
            for (SubCommand child : command.getChildren()) {
                if (!CommandHelpers.matches(args[0], child)) continue;
                CommandHelpers.processChildCommand(sender, child, args);
                return true;
            }
        }
        return false;
    }

    public static boolean matches(String commandName, IModCommand command) {
        if (commandName.equals(command.getCommandName())) {
            return true;
        }
        if (command.getCommandAliases() != null) {
            for (String alias : command.getCommandAliases()) {
                if (!commandName.equals(alias)) continue;
                return true;
            }
        }
        return false;
    }
}

