/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.commands;

import buildcraft.core.lib.commands.CommandHelpers;
import buildcraft.core.lib.commands.IModCommand;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;

public abstract class SubCommand
implements IModCommand {
    private final String name;
    private final List<String> aliases = new ArrayList<String>();
    private PermLevel permLevel = PermLevel.EVERYONE;
    private IModCommand parent;
    private final SortedSet<SubCommand> children = new TreeSet<SubCommand>(new Comparator<SubCommand>(){

        @Override
        public int compare(SubCommand o1, SubCommand o2) {
            return o1.compareTo(o2);
        }
    });

    public SubCommand(String name) {
        this.name = name;
    }

    public final String getCommandName() {
        return this.name;
    }

    public SubCommand addChildCommand(SubCommand child) {
        child.setParent(this);
        this.children.add(child);
        return this;
    }

    void setParent(IModCommand parent) {
        this.parent = parent;
    }

    @Override
    public SortedSet<SubCommand> getChildren() {
        return this.children;
    }

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    @Override
    public List<String> getCommandAliases() {
        return this.aliases;
    }

    public List<?> addTabCompletionOptions(ICommandSender sender, String[] text) {
        return null;
    }

    public final void processCommand(ICommandSender sender, String[] args) {
        if (!CommandHelpers.processStandardCommands(sender, this, args)) {
            this.processSubCommand(sender, args);
        }
    }

    public void processSubCommand(ICommandSender sender, String[] args) {
        CommandHelpers.throwWrongUsage(sender, this);
    }

    public SubCommand setPermLevel(PermLevel permLevel) {
        this.permLevel = permLevel;
        return this;
    }

    @Override
    public final int getMinimumPermissionLevel() {
        return this.permLevel.permLevel;
    }

    public boolean canCommandSenderUseCommand(ICommandSender sender) {
        return sender.canCommandSenderUseCommand(this.getMinimumPermissionLevel(), this.getCommandName());
    }

    public boolean isUsernameIndex(String[] args, int index) {
        return false;
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/" + this.getFullCommandString() + " help";
    }

    @Override
    public void printHelp(ICommandSender sender) {
        CommandHelpers.printHelp(sender, this);
    }

    @Override
    public String getFullCommandString() {
        return this.parent.getFullCommandString() + " " + this.getCommandName();
    }

    public int compareTo(ICommand command) {
        return this.getCommandName().compareTo(command.getCommandName());
    }

    public int compareTo(Object command) {
        return this.compareTo((ICommand)command);
    }

    public static enum PermLevel {
        EVERYONE(0),
        ADMIN(2),
        SERVER_ADMIN(3);

        final int permLevel;

        private PermLevel(int permLevel) {
            this.permLevel = permLevel;
        }
    }
}

