/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.BuildCraftCore;
import buildcraft.api.power.IEngine;
import buildcraft.api.tiles.IHeatable;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.CompatHooks;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.engines.BlockEngineBase;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.core.lib.utils.ResourceUtils;
import buildcraft.core.lib.utils.Utils;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngineBase
extends TileBuildCraft
implements IPipeConnection,
IEnergyHandler,
IEngine,
IHeatable {
    public static final ResourceLocation TRUNK_BLUE_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_blue.png");
    public static final ResourceLocation TRUNK_GREEN_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_green.png");
    public static final ResourceLocation TRUNK_YELLOW_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_yellow.png");
    public static final ResourceLocation TRUNK_RED_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_red.png");
    public static final ResourceLocation TRUNK_OVERHEAT_TEXTURE = new ResourceLocation("buildcraftcore:textures/blocks/engine/trunk_overheat.png");
    public static final float MIN_HEAT = 20.0f;
    public static final float IDEAL_HEAT = 100.0f;
    public static final float MAX_HEAT = 250.0f;
    public int currentOutput = 0;
    public boolean isRedstonePowered = false;
    public float progress;
    public int energy;
    public float heat = 20.0f;
    public EnergyStage energyStage = EnergyStage.BLUE;
    public ForgeDirection orientation = ForgeDirection.UP;
    protected int progressPart = 0;
    private boolean checkOrientation = false;
    private boolean isPumping = false;

    @Override
    public void initialize() {
        if (!this.worldObj.isRemote) {
            this.checkRedstonePower();
        }
    }

    private String getTexturePrefix() {
        if (!(this.blockType instanceof BlockEngineBase)) {
            Block engineBase = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord);
            if (engineBase instanceof BlockEngineBase) {
                this.blockType = engineBase;
                this.getBlockMetadata();
            } else {
                return null;
            }
        }
        return ((BlockEngineBase)this.blockType).getTexturePrefix(this.getBlockMetadata(), true);
    }

    public ResourceLocation getBaseTexture() {
        if (this.getTexturePrefix() != null) {
            return new ResourceLocation(this.getTexturePrefix() + "/base.png");
        }
        return new ResourceLocation("missingno");
    }

    public ResourceLocation getChamberTexture() {
        if (this.getTexturePrefix() != null) {
            return new ResourceLocation(this.getTexturePrefix() + "/chamber.png");
        }
        return new ResourceLocation("missingno");
    }

    public ResourceLocation getTrunkTexture(EnergyStage stage) {
        if (this.getTexturePrefix() == null) {
            return TRUNK_OVERHEAT_TEXTURE;
        }
        if (ResourceUtils.resourceExists(this.getTexturePrefix() + "/trunk.png")) {
            return new ResourceLocation(this.getTexturePrefix() + "/trunk.png");
        }
        switch (stage) {
            case BLUE: {
                return TRUNK_BLUE_TEXTURE;
            }
            case GREEN: {
                return TRUNK_GREEN_TEXTURE;
            }
            case YELLOW: {
                return TRUNK_YELLOW_TEXTURE;
            }
            case RED: {
                return TRUNK_RED_TEXTURE;
            }
            case OVERHEAT: {
                return TRUNK_OVERHEAT_TEXTURE;
            }
        }
        return TRUNK_RED_TEXTURE;
    }

    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        IToolWrench wrench;
        if (!player.worldObj.isRemote && player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IToolWrench && (wrench = (IToolWrench)player.getCurrentEquippedItem().getItem()).canWrench(player, this.xCoord, this.yCoord, this.zCoord)) {
            if (this.getEnergyStage() == EnergyStage.OVERHEAT && !Utils.isFakePlayer(player)) {
                this.energyStage = this.computeEnergyStage();
                this.sendNetworkUpdate();
            }
            this.checkOrientation = true;
            wrench.wrenchUsed(player, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    public double getEnergyLevel() {
        return (double)this.energy / (double)this.getMaxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        float energyLevel = this.getHeatLevel();
        if (energyLevel < 0.25f) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.5f) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.75f) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 1.0f) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (!this.worldObj.isRemote) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                if (this.energyStage == EnergyStage.OVERHEAT) {
                    this.overheat();
                }
                this.sendNetworkUpdate();
            }
        }
        return this.energyStage;
    }

    public void overheat() {
        this.isPumping = false;
        if (BuildCraftCore.canEnginesExplode) {
            this.worldObj.createExplosion(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 3.0f, true);
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void updateHeat() {
        this.heat = (float)(230.0 * this.getEnergyLevel()) + 20.0f;
    }

    public float getHeatLevel() {
        return (this.heat - 20.0f) / 230.0f;
    }

    public float getPistonSpeed() {
        if (!this.worldObj.isRemote) {
            return Math.max(0.16f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.02f;
            }
            case GREEN: {
                return 0.04f;
            }
            case YELLOW: {
                return 0.08f;
            }
            case RED: {
                return 0.16f;
            }
        }
        return 0.0f;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            if (this.progressPart != 0) {
                this.progress += this.getPistonSpeed();
                if (this.progress > 1.0f) {
                    this.progressPart = 0;
                    this.progress = 0.0f;
                }
            } else if (this.isPumping) {
                this.progressPart = 1;
            }
            return;
        }
        if (this.checkOrientation) {
            this.checkOrientation = false;
            if (!this.isOrientationValid()) {
                this.switchOrientation(true);
            }
        }
        this.updateHeat();
        this.getEnergyStage();
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.energy = Math.max(this.energy - 50, 0);
            return;
        }
        this.engineUpdate();
        Object tile = this.getEnergyProvider(this.orientation);
        if (this.progressPart != 0) {
            this.progress += this.getPistonSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.isPoweredTile(tile, this.orientation)) {
                this.progressPart = 1;
                this.setPumping(true);
                if (this.getPowerToExtract() > 0) {
                    this.progressPart = 1;
                    this.setPumping(true);
                } else {
                    this.setPumping(false);
                }
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        this.burn();
        if (!this.isRedstonePowered) {
            this.currentOutput = 0;
        } else if (this.isRedstonePowered && this.isActive()) {
            this.sendPower();
        }
    }

    public Object getEnergyProvider(ForgeDirection orientation) {
        return CompatHooks.INSTANCE.getEnergyProvider(this.getTile(orientation));
    }

    private int getPowerToExtract() {
        Object tile = this.getEnergyProvider(this.orientation);
        if (tile instanceof IEngine) {
            IEngine engine = (IEngine)tile;
            int maxEnergy = engine.receiveEnergyFromEngine(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        if (tile instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tile;
            int maxEnergy = handler.receiveEnergy(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            int maxEnergy = handler.receiveEnergy(this.orientation.getOpposite(), this.energy, true);
            return this.extractEnergy(maxEnergy, false);
        }
        return 0;
    }

    protected void sendPower() {
        Object tile = this.getEnergyProvider(this.orientation);
        if (this.isPoweredTile(tile, this.orientation)) {
            int extracted = this.getPowerToExtract();
            if (extracted <= 0) {
                this.setPumping(false);
                return;
            }
            this.setPumping(true);
            if (tile instanceof IEngine) {
                IEngine engine = (IEngine)tile;
                int neededRF = engine.receiveEnergyFromEngine(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            } else if (tile instanceof IEnergyHandler) {
                IEnergyHandler handler = (IEnergyHandler)tile;
                int neededRF = handler.receiveEnergy(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            } else if (tile instanceof IEnergyReceiver) {
                IEnergyReceiver handler = (IEnergyReceiver)tile;
                int neededRF = handler.receiveEnergy(this.orientation.getOpposite(), extracted, false);
                this.extractEnergy(neededRF, true);
            }
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.energy >= 10) {
                this.energy -= 10;
            } else if (this.energy < 10) {
                this.energy = 0;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate();
    }

    public boolean isOrientationValid() {
        Object tile = this.getEnergyProvider(this.orientation);
        return this.isPoweredTile(tile, this.orientation);
    }

    public boolean switchOrientation(boolean preferPipe) {
        if (preferPipe && this.switchOrientationDo(true)) {
            return true;
        }
        return this.switchOrientationDo(false);
    }

    private boolean switchOrientationDo(boolean pipesOnly) {
        for (int i = this.orientation.ordinal() + 1; i <= this.orientation.ordinal() + 6; ++i) {
            ForgeDirection o = ForgeDirection.VALID_DIRECTIONS[i % 6];
            Object tile = this.getEnergyProvider(o);
            if (pipesOnly && !(tile instanceof IPipeTile) || !this.isPoweredTile(tile, o)) continue;
            this.orientation = o;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord));
            return true;
        }
        return false;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.checkOrientation = true;
    }

    @Override
    public void validate() {
        super.validate();
        this.checkOrientation = true;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = ForgeDirection.getOrientation((int)data.getByte("orientation"));
        this.progress = data.getFloat("progress");
        this.energy = data.getInteger("energy");
        this.heat = data.getFloat("heat");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("orientation", (byte)this.orientation.ordinal());
        data.setFloat("progress", this.progress);
        data.setInteger("energy", this.energy);
        data.setFloat("heat", this.heat);
    }

    @Override
    public void readData(ByteBuf stream) {
        short flags = stream.readUnsignedByte();
        this.energyStage = EnergyStage.values()[flags & 7];
        this.isPumping = (flags & 8) != 0;
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeByte(this.energyStage.ordinal() | (this.isPumping ? 8 : 0));
        stream.writeByte(this.orientation.ordinal());
    }

    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.energy = this.energy & 0xFFFF0000 | value & 0xFFFF;
                break;
            }
            case 1: {
                this.energy = this.energy & 0xFFFF | (value & 0xFFFF) << 16;
                break;
            }
            case 2: {
                this.currentOutput = value;
                break;
            }
            case 3: {
                this.heat = (float)value / 100.0f;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.energy & 0xFFFF);
        iCrafting.sendProgressBarUpdate(container, 1, (this.energy & 0xFFFF0000) >> 16);
        iCrafting.sendProgressBarUpdate(container, 2, this.currentOutput);
        iCrafting.sendProgressBarUpdate(container, 3, Math.round(this.heat * 100.0f));
    }

    public abstract boolean isBurning();

    public void addEnergy(int addition) {
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            return;
        }
        this.energy += addition;
        if (this.energy > this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    public int extractEnergy(int energyMax, boolean doExtract) {
        int extracted;
        int max = Math.min(energyMax, this.getCurrentOutputLimit());
        if (this.energy >= max) {
            extracted = max;
            if (doExtract) {
                this.energy -= max;
            }
        } else {
            extracted = this.energy;
            if (doExtract) {
                this.energy = 0;
            }
        }
        return extracted;
    }

    public boolean isPoweredTile(Object tile, ForgeDirection side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEngine) {
            return ((IEngine)tile).canReceiveFromEngine(side.getOpposite());
        }
        if (tile instanceof IEnergyHandler || tile instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
        }
        return false;
    }

    public abstract int getMaxEnergy();

    public int getEnergyStored() {
        return this.energy;
    }

    public abstract int getIdealOutput();

    public int getCurrentOutputLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.orientation) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    public void checkRedstonePower() {
        this.isRedstonePowered = this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
    }

    public void onNeighborUpdate() {
        this.checkRedstonePower();
        this.checkOrientation = true;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (from != this.orientation) {
            return 0;
        }
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergy();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.orientation;
    }

    @Override
    public boolean canReceiveFromEngine(ForgeDirection side) {
        return side == this.orientation.getOpposite();
    }

    @Override
    public int receiveEnergyFromEngine(ForgeDirection side, int amount, boolean simulate) {
        if (this.canReceiveFromEngine(side)) {
            int targetEnergy = Math.min(this.getMaxEnergy() - this.energy, amount);
            if (!simulate) {
                this.energy += targetEnergy;
            }
            return targetEnergy;
        }
        return 0;
    }

    @Override
    public double getMinHeatValue() {
        return 20.0;
    }

    @Override
    public double getIdealHeatValue() {
        return 100.0;
    }

    @Override
    public double getMaxHeatValue() {
        return 250.0;
    }

    @Override
    public double getCurrentHeatValue() {
        return this.heat;
    }

    @Override
    public double setHeatValue(double value) {
        this.heat = (float)MathUtils.clamp(value, 20.0, 250.0);
        return this.heat;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        static {
            VALUES = EnergyStage.values();
        }
    }
}

