/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEngineWithInventory
extends TileEngineBase
implements IInventory,
ISidedInventory {
    private final SimpleInventory inv;
    private final int[] defaultSlotArray;

    public TileEngineWithInventory(int invSize) {
        this.inv = new SimpleInventory(invSize, "Engine", 64);
        this.defaultSlotArray = Utils.createSlotArray(0, invSize);
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inv.setInventorySlotContents(slot, itemstack);
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public String getInventoryName() {
        return "Engine";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT(data);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (side == this.orientation.ordinal()) {
            return new int[0];
        }
        return this.defaultSlotArray;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return side != this.orientation.ordinal();
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return side != this.orientation.ordinal();
    }
}

