/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui;

import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.IPhantomSlot;
import buildcraft.core.lib.gui.tooltips.IToolTipProvider;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.gui.widgets.Widget;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.lib.utils.SessionVars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class GuiBuildCraft
extends GuiContainer {
    public static final ResourceLocation LEDGER_TEXTURE = new ResourceLocation("buildcraftcore:textures/gui/ledger.png");
    public final LedgerManager ledgerManager = new LedgerManager(this);
    public final TileEntity tile;
    public final BuildCraftContainer container;
    public ResourceLocation texture;

    public GuiBuildCraft(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super((Container)container);
        this.container = container;
        this.texture = texture;
        this.tile = inventory instanceof TileEntity ? (TileEntity)inventory : null;
        this.initLedgers(inventory);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }

    protected void initLedgers(IInventory inventory) {
    }

    public void drawScreen(int mouseX, int mouseY, float par3) {
        super.drawScreen(mouseX, mouseY, par3);
        int left = this.guiLeft;
        int top = this.guiTop;
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)left, (float)top, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.disableStandardItemLighting();
        InventoryPlayer playerInv = this.mc.thePlayer.inventory;
        if (playerInv.getItemStack() == null) {
            this.drawToolTips(this.container.getWidgets(), mouseX - left, mouseY - top, left, top);
            this.drawToolTips(this.buttonList, mouseX, mouseY, 0, 0);
            this.drawToolTips(this.inventorySlots.inventorySlots, mouseX, mouseY, 0, 0);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
    }

    private void drawToolTips(Collection<?> objects, int mouseX, int mouseY, int offsetX, int offsetY) {
        for (Object obj : objects) {
            ToolTip tips;
            IToolTipProvider provider;
            if (!(obj instanceof IToolTipProvider) || !(provider = (IToolTipProvider)obj).isToolTipVisible() || (tips = provider.getToolTip()) == null) continue;
            boolean mouseOver = provider.isMouseOver(mouseX, mouseY);
            tips.onTick(mouseOver);
            if (!mouseOver || !tips.isReady()) continue;
            tips.refresh();
            this.drawToolTips(tips, mouseX + offsetX, mouseY + offsetY);
        }
    }

    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int i;
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        IIcon icon = fluid.getFluid().getIcon(fluid);
        if (icon == null) {
            icon = ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.locationBlocksTexture)).getAtlasSprite("missingno");
        }
        this.mc.renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        RenderUtils.setGLColorFromInt(fluid.getFluid().getColor(fluid));
        int fullX = width / 16;
        int fullY = height / 16;
        int lastX = width - fullX * 16;
        int lastY = height - fullY * 16;
        int level = fluid.amount * height / maxCapacity;
        int fullLvl = (height - level) / 16;
        int lastLvl = height - level - fullLvl * 16;
        for (i = 0; i < fullX; ++i) {
            for (int j = 0; j < fullY; ++j) {
                if (j < fullLvl) continue;
                this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
            }
        }
        for (i = 0; i < fullX; ++i) {
            this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
        }
        for (i = 0; i < fullY; ++i) {
            if (i < fullLvl) continue;
            this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
        }
        this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        tess.addVertexWithUV((double)x, (double)(y + height), (double)this.zLevel, (double)icon.getMinU(), (double)icon.getInterpolatedV((double)height));
        tess.addVertexWithUV((double)(x + width), (double)(y + height), (double)this.zLevel, (double)icon.getInterpolatedU((double)width), (double)icon.getInterpolatedV((double)height));
        tess.addVertexWithUV((double)(x + width), (double)(y + cut), (double)this.zLevel, (double)icon.getInterpolatedU((double)width), (double)icon.getInterpolatedV((double)cut));
        tess.addVertexWithUV((double)x, (double)(y + cut), (double)this.zLevel, (double)icon.getMinU(), (double)icon.getInterpolatedV((double)cut));
        tess.draw();
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        this.drawWidgets(mX, mY);
    }

    protected void drawWidgets(int mX, int mY) {
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            this.bindTexture(this.texture);
            widget.draw(this, this.guiLeft, this.guiTop, mX, mY);
        }
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.drawLedgers(par1, par2);
    }

    protected void drawLedgers(int x, int y) {
        this.ledgerManager.drawLedgers(x, y);
    }

    public void drawCenteredString(String string, int xCenter, int yCenter, int textColor) {
        this.fontRendererObj.drawString(string, xCenter - this.fontRendererObj.getStringWidth(string) / 2, yCenter - this.fontRendererObj.FONT_HEIGHT / 2, textColor);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        int left = this.guiLeft;
        int top = this.guiTop;
        int realMouseX = mouseX - left;
        int realMouseY = mouseY - top;
        return realMouseX >= slot.xDisplayPosition - 1 && realMouseX < slot.xDisplayPosition + 16 + 1 && realMouseY >= slot.yDisplayPosition - 1 && realMouseY < slot.yDisplayPosition + 16 + 1;
    }

    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden || !widget.isMouseOver(mX, mY) || !widget.handleMouseClick(mX, mY, mouseButton)) continue;
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.ledgerManager.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void mouseClickMove(int mouseX, int mouseY, int mouseButton, long time) {
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            widget.handleMouseMove(mX, mY, mouseButton, time);
        }
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        if (mouseButton == 1 && slot instanceof IPhantomSlot) {
            return;
        }
        super.mouseClickMove(mouseX, mouseY, mouseButton, time);
    }

    protected void mouseMovedOrUp(int mouseX, int mouseY, int eventType) {
        super.mouseMovedOrUp(mouseX, mouseY, eventType);
        int mX = mouseX - this.guiLeft;
        int mY = mouseY - this.guiTop;
        for (Widget widget : this.container.getWidgets()) {
            if (widget.hidden) continue;
            widget.handleMouseRelease(mX, mY, eventType);
        }
    }

    public Slot getSlotAtPosition(int x, int y) {
        for (int slotIndex = 0; slotIndex < this.inventorySlots.inventorySlots.size(); ++slotIndex) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(slotIndex);
            if (!this.isMouseOverSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    public void bindTexture(ResourceLocation texture) {
        Minecraft.getMinecraft().renderEngine.bindTexture(texture);
    }

    private void drawToolTips(ToolTip toolTips, int mouseX, int mouseY) {
        if (toolTips.size() > 0) {
            int y;
            int left = this.guiLeft;
            int top = this.guiTop;
            int length = 0;
            Iterator iterator = toolTips.iterator();
            while (iterator.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator.next();
                y = this.fontRendererObj.getStringWidth(tip.text);
                if (y <= length) continue;
                length = y;
            }
            int x = mouseX - left + 12;
            y = mouseY - top - 12;
            int var14 = 8;
            if (toolTips.size() > 1) {
                var14 += 2 + (toolTips.size() - 1) * 10;
            }
            this.zLevel = 300.0f;
            GuiBuildCraft.itemRender.zLevel = 300.0f;
            int var15 = -267386864;
            this.drawGradientRect(x - 3, y - 4, x + length + 3, y - 3, var15, var15);
            this.drawGradientRect(x - 3, y + var14 + 3, x + length + 3, y + var14 + 4, var15, var15);
            this.drawGradientRect(x - 3, y - 3, x + length + 3, y + var14 + 3, var15, var15);
            this.drawGradientRect(x - 4, y - 3, x - 3, y + var14 + 3, var15, var15);
            this.drawGradientRect(x + length + 3, y - 3, x + length + 4, y + var14 + 3, var15, var15);
            int var16 = 0x505000FF;
            int var17 = (var16 & 0xFEFEFE) >> 1 | var16 & 0xFF000000;
            this.drawGradientRect(x - 3, y - 3 + 1, x - 3 + 1, y + var14 + 3 - 1, var16, var17);
            this.drawGradientRect(x + length + 2, y - 3 + 1, x + length + 3, y + var14 + 3 - 1, var16, var17);
            this.drawGradientRect(x - 3, y - 3, x + length + 3, y - 3 + 1, var16, var16);
            this.drawGradientRect(x - 3, y + var14 + 2, x + length + 3, y + var14 + 3, var17, var17);
            Iterator iterator2 = toolTips.iterator();
            while (iterator2.hasNext()) {
                ToolTipLine tip = (ToolTipLine)iterator2.next();
                String line = tip.text;
                line = tip.color == -1 ? "\u00a77" + line : "\u00a7" + Integer.toHexString(tip.color) + line;
                this.fontRendererObj.drawStringWithShadow(line, x, y, -1);
                y += 10 + tip.getSpacing();
            }
            this.zLevel = 0.0f;
            GuiBuildCraft.itemRender.zLevel = 0.0f;
        }
    }

    public BuildCraftContainer getContainer() {
        return this.container;
    }

    protected abstract class Ledger {
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int overlayColor = 0xFFFFFF;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;
        private boolean open;
        private long lastUpdateTime = -1L;

        protected Ledger() {
        }

        public void update() {
            if (this.lastUpdateTime < 0L) {
                this.lastUpdateTime = new Date().getTime();
            }
            long updateTime = new Date().getTime();
            int updateVal = (int)Math.round((double)(updateTime - this.lastUpdateTime) / 8.0);
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += updateVal;
                this.currentWidth = Math.min(this.maxWidth, this.currentWidth);
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= updateVal;
                this.currentWidth = Math.max(this.minWidth, this.currentWidth);
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += updateVal;
                this.currentHeight = Math.min(this.maxWidth, this.currentHeight);
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= updateVal;
                this.currentHeight = Math.max(this.minHeight, this.currentHeight);
            }
            this.lastUpdateTime = updateTime;
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y) {
            RenderUtils.setGLColorFromInt(this.overlayColor);
            GuiBuildCraft.this.mc.renderEngine.bindTexture(LEDGER_TEXTURE);
            GuiBuildCraft.this.drawTexturedModalRect(x, y, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiBuildCraft.this.drawTexturedModalRect(x + 4, y, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiBuildCraft.this.drawTexturedModalRect(x, y, 0, 0, 4, 4);
            GuiBuildCraft.this.drawTexturedModalRect(x + 4, y + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(IIcon icon, int x, int y) {
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBuildCraft.this.drawTexturedModelRectFromIcon(x, y, icon, 16, 16);
        }
    }

    protected class LedgerManager {
        protected ArrayList<Ledger> ledgers = new ArrayList();
        private GuiBuildCraft gui;

        public LedgerManager(GuiBuildCraft gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.width - this.gui.xSize) / 2 + this.gui.xSize;
            int yShift = (this.gui.height - this.gui.ySize) / 2 + 8;
            for (Ledger ledger : this.ledgers) {
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int yPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiBuildCraft.this.xSize, yPos);
                yPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.width - this.gui.xSize) / 2 + 12;
                int startY = mouseY - (this.gui.height - this.gui.ySize) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiBuildCraft.this.fontRendererObj.getStringWidth(tooltip);
                GuiBuildCraft.this.drawGradientRect(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiBuildCraft.this.fontRendererObj.drawStringWithShadow(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }
}

