/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.buttons;

import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.buttons.IButtonTextureSet;
import buildcraft.core.lib.gui.buttons.MultiButtonController;
import buildcraft.core.lib.gui.buttons.StandardButtonTextureSets;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiMultiButton
extends GuiBetterButton {
    private final MultiButtonController<?> control;

    public GuiMultiButton(int id, int x, int y, int width, MultiButtonController<?> control) {
        super(id, x, y, width, StandardButtonTextureSets.LARGE_BUTTON, "");
        this.control = control;
    }

    @Override
    public int getHeight() {
        return this.texture.getHeight();
    }

    @Override
    public void drawButton(Minecraft minecraft, int x, int y) {
        if (!this.visible) {
            return;
        }
        FontRenderer fontrenderer = minecraft.fontRenderer;
        this.bindButtonTextures(minecraft);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Object state = this.control.getButtonState();
        IButtonTextureSet tex = state.getTextureSet();
        int xOffset = tex.getX();
        int yOffset = tex.getY();
        int h = tex.getHeight();
        int w = tex.getWidth();
        boolean flag = x >= this.xPosition && y >= this.yPosition && x < this.xPosition + this.width && y < this.yPosition + h;
        int hoverState = this.getHoverState(flag);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, xOffset, yOffset + hoverState * h, this.width / 2, h);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, xOffset + w - this.width / 2, yOffset + hoverState * h, this.width / 2, h);
        this.mouseDragged(minecraft, x, y);
        this.displayString = state.getLabel();
        if (!"".equals(this.displayString)) {
            if (!this.enabled) {
                this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (h - 8) / 2, -6250336);
            } else if (flag) {
                this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (h - 8) / 2, 0xFFFFA0);
            } else {
                this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (h - 8) / 2, 0xE0E0E0);
            }
        }
    }

    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        boolean pressed = super.mousePressed(par1Minecraft, par2, par3);
        if (pressed && this.enabled) {
            this.control.incrementState();
        }
        return pressed;
    }

    public MultiButtonController<?> getController() {
        return this.control;
    }

    @Override
    public ToolTip getToolTip() {
        ToolTip tip = this.control.getButtonState().getToolTip();
        if (tip != null) {
            return tip;
        }
        return super.getToolTip();
    }
}

