/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.InventoryWrapperSimple;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public abstract class InventoryWrapper
implements ISidedInventory {
    IInventory inventory;

    public InventoryWrapper(IInventory inventory) {
        this.inventory = inventory;
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory.getStackInSlot(slotIndex);
    }

    public ItemStack decrStackSize(int slotIndex, int amount) {
        return this.inventory.decrStackSize(slotIndex, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        return this.inventory.getStackInSlotOnClosing(slotIndex);
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemstack) {
        this.inventory.setInventorySlotContents(slotIndex, itemstack);
    }

    public String getInventoryName() {
        return this.inventory.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inventory.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inventory.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inventory.openInventory();
    }

    public void closeInventory() {
        this.inventory.closeInventory();
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemstack) {
        return this.inventory.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean hasCustomInventoryName() {
        return this.inventory.hasCustomInventoryName();
    }

    public static ISidedInventory getWrappedInventory(Object inventory) {
        if (inventory instanceof ISidedInventory) {
            return (ISidedInventory)inventory;
        }
        if (inventory instanceof IInventory) {
            return new InventoryWrapperSimple(InvUtils.getInventory((IInventory)inventory));
        }
        return null;
    }
}

