/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.ISerializable;
import buildcraft.core.lib.network.ISyncedTile;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketEntityUpdate;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandler
extends SimpleChannelInboundHandler<Packet> {
    private void onTileUpdate(EntityPlayer player, PacketTileUpdate packet) throws IOException {
        World world = player.worldObj;
        if (!packet.targetExists(world)) {
            return;
        }
        TileEntity entity = packet.getTarget(world);
        if (!(entity instanceof ISerializable)) {
            return;
        }
        ISerializable tile = (ISerializable)entity;
        tile.readData(packet.stream);
    }

    private void onEntityUpdate(EntityPlayer player, PacketEntityUpdate packet) throws IOException {
        World world = player.worldObj;
        if (!packet.targetExists(world)) {
            return;
        }
        Entity entity = packet.getTarget(world);
        if (!(entity instanceof ISerializable)) {
            return;
        }
        ISerializable payload = (ISerializable)entity;
        payload.readData(packet.stream);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Packet packet) {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 0: {
                    this.onTileUpdate(player, (PacketTileUpdate)packet);
                    break;
                }
                case 7: {
                    this.onEntityUpdate(player, (PacketEntityUpdate)packet);
                    break;
                }
                case 1: {
                    ((PacketCommand)packet).handle(player);
                    break;
                }
                case 100: {
                    PacketTileState pkt = (PacketTileState)packet;
                    World world = player.worldObj;
                    TileEntity tile = world.getTileEntity(pkt.posX, pkt.posY, pkt.posZ);
                    if (!(tile instanceof ISyncedTile)) break;
                    pkt.applyStates((ISyncedTile)tile);
                    break;
                }
                case 80: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

