/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.PacketCoordinates;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class PacketNBT
extends PacketCoordinates {
    private NBTTagCompound nbttagcompound;

    public PacketNBT() {
    }

    public PacketNBT(int id, NBTTagCompound nbttagcompound, int xCoord, int yCoord, int zCoord) {
        super(id, xCoord, yCoord, zCoord);
        this.nbttagcompound = nbttagcompound;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        try {
            byte[] compressed = CompressedStreamTools.compress((NBTTagCompound)this.nbttagcompound);
            if (compressed.length > 65535) {
                BCLog.logger.error("NBT data is too large (" + compressed.length + " > 65535)! Please report!");
            }
            data.writeShort(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        int length = data.readUnsignedShort();
        byte[] compressed = new byte[length];
        data.readBytes(compressed);
        try {
            this.nbttagcompound = CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NBTTagCompound getTagCompound() {
        return this.nbttagcompound;
    }
}

