/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.render;

import net.minecraft.util.IIcon;

public class SubIcon
implements IIcon {
    private final IIcon icon;
    private float u;
    private float v;
    private final int w;
    private final int h;
    private float uScale;
    private float vScale;
    private int iw;
    private int ih;

    public SubIcon(IIcon icon, int u, int v, int size) {
        this(icon, u, v, 16, 16, size);
    }

    public SubIcon(IIcon icon, int u, int v, int w, int h, int size) {
        this.iw = size;
        this.ih = size;
        this.icon = icon;
        this.uScale = icon.getMaxU() - icon.getMinU();
        this.vScale = icon.getMaxV() - icon.getMinV();
        this.u = icon.getMinU() + this.uScale * (float)u / (float)this.iw;
        this.v = icon.getMinV() + this.vScale * (float)v / (float)this.ih;
        this.w = w;
        this.h = h;
    }

    public int getIconWidth() {
        return this.w;
    }

    public int getIconHeight() {
        return this.h;
    }

    public float getMinU() {
        return this.u;
    }

    public float getMaxU() {
        return this.u + this.uScale * (float)this.w / (float)this.iw;
    }

    public float getInterpolatedU(double uu) {
        return this.u + this.uScale * (float)uu / (float)this.iw;
    }

    public float getMinV() {
        return this.v;
    }

    public float getMaxV() {
        return this.v + this.vScale * (float)this.h / (float)this.ih;
    }

    public float getInterpolatedV(double vv) {
        return this.v + this.vScale * (float)vv / (float)this.ih;
    }

    public String getIconName() {
        return this.icon.getIconName();
    }
}

