/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BlockIndex;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.MathHelper;

public class BlockScannerRandom
implements Iterable<BlockIndex> {
    private Random rand;
    private int maxDistance;

    public BlockScannerRandom(Random iRand, int iMaxDistance) {
        this.rand = iRand;
        this.maxDistance = iMaxDistance;
    }

    @Override
    public Iterator<BlockIndex> iterator() {
        return new BlockIt();
    }

    class BlockIt
    implements Iterator<BlockIndex> {
        BlockIt() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public BlockIndex next() {
            double radius = BlockScannerRandom.this.rand.nextFloat() * (float)BlockScannerRandom.this.maxDistance;
            float polarAngle = BlockScannerRandom.this.rand.nextFloat() * 2.0f * (float)Math.PI;
            float azimuthAngle = BlockScannerRandom.this.rand.nextFloat() * (float)Math.PI;
            int searchX = (int)(radius * (double)MathHelper.cos((float)polarAngle) * (double)MathHelper.sin((float)azimuthAngle));
            int searchY = (int)(radius * (double)MathHelper.cos((float)azimuthAngle));
            int searchZ = (int)(radius * (double)MathHelper.sin((float)polarAngle) * (double)MathHelper.sin((float)azimuthAngle));
            return new BlockIndex(searchX, searchY, searchZ);
        }

        @Override
        public void remove() {
        }
    }
}

