/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.ThreadSafeUtils;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static List<ItemStack> getItemStackFromBlock(WorldServer world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        if (block == null || block.isAir((IBlockAccess)world, i, j, k)) {
            return null;
        }
        int meta = world.getBlockMetadata(i, j, k);
        ArrayList dropsList = block.getDrops((World)world, i, j, k, meta, 0);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)dropsList, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get()));
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.rand.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z) {
        return BlockUtils.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan * 20);
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z, int forcedLifespan) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (BlockUtils.breakBlock(world, x, y, z, items)) {
            for (ItemStack item : items) {
                BlockUtils.dropItem(world, x, y, z, forcedLifespan, item);
            }
            return true;
        }
        return false;
    }

    public static EntityPlayer getFakePlayerWithTool(WorldServer world, int x, int y, int z, ItemStack tool) {
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, x, y, z).get();
        for (int i = 0; player.getHeldItem() != tool && i < 9; ++i) {
            if (i > 0) {
                player.inventory.setInventorySlotContents(i - 1, null);
            }
            player.inventory.setInventorySlotContents(i, tool);
        }
        return player;
    }

    public static boolean harvestBlock(WorldServer world, int x, int y, int z, ItemStack tool) {
        Block block = world.getBlock(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        EntityPlayer player = BlockUtils.getFakePlayerWithTool(world, x, y, z, tool);
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, (World)world, world.getBlock(x, y, z), world.getBlockMetadata(x, y, z), player);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!block.canHarvestBlock(player, meta)) {
            return false;
        }
        if (tool != null && tool.getItem() != null && tool.getItem().onBlockStartBreak(tool, x, y, z, player)) {
            return false;
        }
        block.onBlockHarvested((World)world, x, y, z, meta, player);
        block.harvestBlock((World)world, player, x, y, z, meta);
        world.setBlockToAir(x, y, z);
        return true;
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z, List<ItemStack> drops) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, (World)world, world.getBlock(x, y, z), world.getBlockMetadata(x, y, z), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get());
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!world.isAirBlock(x, y, z) && !world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            drops.addAll(BlockUtils.getItemStackFromBlock(world, x, y, z));
        }
        world.setBlockToAir(x, y, z);
        return true;
    }

    public static void dropItem(WorldServer world, int x, int y, int z, int forcedLifespan, ItemStack stack) {
        float var = 0.7f;
        double dx = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dy = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dz = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        EntityItem entityitem = new EntityItem((World)world, (double)x + dx, (double)y + dy, (double)z + dz, stack);
        entityitem.lifespan = forcedLifespan;
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtils.canChangeBlock(world.getBlock(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(Block block, World world, int x, int y, int z) {
        Fluid f;
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (BlockUtils.isUnbreakableBlock(world, x, y, z, block)) {
            return false;
        }
        if (block == Blocks.lava || block == Blocks.flowing_lava) {
            return false;
        }
        return !(block instanceof IFluidBlock) || ((IFluidBlock)block).getFluid() == null || (f = ((IFluidBlock)block).getFluid()).getDensity(world, x, y, z) < 3000;
    }

    public static float getBlockHardnessMining(World world, int x, int y, int z, Block b, ItemStack tool) {
        float relativeHardness;
        if (world instanceof WorldServer && !BuildCraftCore.miningAllowPlayerProtectedBlocks && (relativeHardness = b.getPlayerRelativeBlockHardness(BlockUtils.getFakePlayerWithTool((WorldServer)world, x, y, z, tool), world, x, y, z)) <= 0.0f) {
            return -1.0f;
        }
        return b.getBlockHardness(world, x, y, z);
    }

    public static boolean isUnbreakableBlock(World world, int x, int y, int z, Block b) {
        if (b == null) {
            return false;
        }
        return BlockUtils.getBlockHardnessMining(world, x, y, z, b, null) < 0.0f;
    }

    public static boolean isUnbreakableBlock(World world, int x, int y, int z) {
        return BlockUtils.isUnbreakableBlock(world, x, y, z, world.getBlock(x, y, z));
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.getBlock(x, y, z).getMaterial().isToolNotRequired();
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return BlockUtils.isFullFluidBlock(world.getBlock(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFilledPercentage(world, x, y, z) == 1.0f;
        }
        if (block instanceof BlockStaticLiquid) {
            return world.getBlockMetadata(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return BlockUtils.drainBlock(world.getBlock(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            if (!fluidBlock.canDrain(world, x, y, z)) {
                return null;
            }
            return fluidBlock.drain(world, x, y, z, doDrain);
        }
        Fluid fluid = BlockUtils.getFluid(block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            int meta = world.getBlockMetadata(x, y, z);
            if (meta != 0) {
                return null;
            }
            if (doDrain) {
                world.setBlockToAir(x, y, z);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.affectedBlockPositions.add(new ChunkPosition(x, y, z));
        explosion.doExplosionB(true);
        for (EntityPlayer player : world.playerEntities) {
            if (!(player instanceof EntityPlayerMP) || !(player.getDistanceSq((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S27PacketExplosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.affectedBlockPositions, null));
        }
    }

    public static int computeBlockBreakEnergy(World world, int x, int y, int z) {
        return (int)Math.floor(160.0f * BuildCraftCore.miningMultiplier * ((world.getBlock(x, y, z).getBlockHardness(world, x, y, z) + 1.0f) * 2.0f));
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z) {
        return BlockUtils.getTileEntity(world, x, y, z, false);
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return null;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.getTileEntityUnsafe(x & 0xF, y, z & 0xF) : null;
        }
        return world.getTileEntity(x, y, z);
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return BlockUtils.getBlock(world, x, y, z, false);
    }

    public static Block getBlock(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return Blocks.air;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.getBlock(x & 0xF, y, z & 0xF) : Blocks.air;
        }
        return world.getBlock(x, y, z);
    }

    public static int getBlockMetadata(World world, int x, int y, int z) {
        return BlockUtils.getBlockMetadata(world, x, y, z, false);
    }

    public static int getBlockMetadata(World world, int x, int y, int z, boolean force) {
        if (!force) {
            if (y < 0 || y > 255) {
                return 0;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, x >> 4, z >> 4);
            return chunk != null ? chunk.getBlockMetadata(x & 0xF, y, z & 0xF) : 0;
        }
        return world.getBlockMetadata(x, y, z);
    }

    public static boolean useItemOnBlock(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection direction) {
        boolean done = stack.getItem().onItemUseFirst(stack, player, world, x, y, z, direction.ordinal(), 0.5f, 0.5f, 0.5f);
        if (!done) {
            done = stack.getItem().onItemUse(stack, player, world, x, y, z, direction.ordinal(), 0.5f, 0.5f, 0.5f);
        }
        return done;
    }

    public static void onComparatorUpdate(World world, int x, int y, int z, Block block) {
        world.func_147453_f(x, y, z, block);
    }

    public static TileEntityChest getOtherDoubleChest(TileEntity inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            if (chest.adjacentChestXNeg != null) {
                adjacent = chest.adjacentChestXNeg;
            }
            if (chest.adjacentChestXPos != null) {
                adjacent = chest.adjacentChestXPos;
            }
            if (chest.adjacentChestZNeg != null) {
                adjacent = chest.adjacentChestZNeg;
            }
            if (chest.adjacentChestZPos != null) {
                adjacent = chest.adjacentChestZPos;
            }
            return adjacent;
        }
        return null;
    }
}

