/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.properties;

import buildcraft.api.core.IWorldProperty;
import buildcraft.core.properties.DimensionProperty;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class WorldProperty
implements IWorldProperty {
    public HashMap<Integer, DimensionProperty> properties = new HashMap();

    @Override
    public synchronized boolean get(World world, int x, int y, int z) {
        return this.getDimension(world).get(x, y, z);
    }

    private DimensionProperty getDimension(World world) {
        DimensionProperty result;
        int id = world.provider.dimensionId * 2;
        if (world.isRemote) {
            ++id;
        }
        if ((result = this.properties.get(id)) == null) {
            result = new DimensionProperty(world, this);
            this.properties.put(id, result);
        }
        return result;
    }

    @Override
    public void clear() {
        for (DimensionProperty p : this.properties.values()) {
            if (p == null) continue;
            p.clear();
        }
        this.properties.clear();
    }

    protected abstract boolean get(IBlockAccess var1, Block var2, int var3, int var4, int var5, int var6);
}

