/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.api.tablet.TabletBitmap;
import buildcraft.core.lib.render.DynamicTextureBC;
import buildcraft.core.tablet.TabletClient;
import buildcraft.core.tablet.manager.TabletManagerClient;
import buildcraft.core.tablet.manager.TabletThread;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiTablet
extends GuiScreen {
    private static final boolean ENABLE_HIGHLIGHT = false;
    private static final int[] PALETTE = new int[]{0, 0x1C000000, 0x30000000, 0x48000000, 0x60000000, 0x78000000, -1711276032, -1140850688};
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftcore", "textures/gui/tablet.png");
    private static final int X_SIZE = 142;
    private static final int Y_SIZE = 180;
    private final DynamicTextureBC display;
    private final TabletThread tabletThread = TabletManagerClient.INSTANCE.get();
    private final TabletClient tablet = (TabletClient)this.tabletThread.getTablet();
    private int guiLeft;
    private int guiTop;
    private long lastDate = new Date().getTime();
    private float glScale = 1.0f;
    private int buttonState = 1;

    public GuiTablet(EntityPlayer player) {
        this.display = new DynamicTextureBC(this.tablet.getScreenWidth(), this.tablet.getScreenHeight());
        this.tablet.updateGui(0.0f, this, true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void initGui() {
        super.initGui();
        int oldScale = this.mc.gameSettings.guiScale;
        ScaledResolution realRes = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
        this.mc.gameSettings.guiScale = realRes.getScaleFactor() == 1 ? 2 : realRes.getScaleFactor() & 0xFFFFFFFE;
        ScaledResolution currentRes = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
        this.mc.gameSettings.guiScale = oldScale;
        this.glScale = (float)(currentRes.getScaledWidth_double() / realRes.getScaledWidth_double());
        this.guiLeft = (currentRes.getScaledWidth() - 142) / 2;
        this.guiTop = (currentRes.getScaledHeight() - 180) / 2;
    }

    public void bindTexture(ResourceLocation texture) {
        Minecraft.getMinecraft().renderEngine.bindTexture(texture);
    }

    public void copyDisplay(TabletBitmap display) {
        for (int j = 0; j < display.height; ++j) {
            for (int i = 0; i < display.width; ++i) {
                this.display.setColor(i, j, PALETTE[display.get(i, j) & 7]);
            }
        }
    }

    public void updateScreen() {
        long date = new Date().getTime();
        float time = (float)(date - this.lastDate) / 1000.0f;
        this.tabletThread.tick(time);
        this.lastDate = date;
        this.tablet.updateGui(time, this, false);
    }

    private boolean isButton(int mx, int my) {
        return mx >= this.guiLeft + 65 && my >= this.guiTop + 167 && mx < this.guiLeft + 65 + 18 && my < this.guiTop + 167 + 8;
    }

    public void handleMouseInput() {
        int x = (int)((float)(Mouse.getEventX() * this.width / this.mc.displayWidth) * this.glScale);
        int y = (int)((float)(this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1) * this.glScale);
        int k = Mouse.getEventButton();
        if (k == 0) {
            if (Mouse.getEventButtonState()) {
                if (this.isButton(x, y)) {
                    this.buttonState = 2;
                }
            } else if (this.buttonState == 2) {
                this.buttonState = this.isButton(x, y) ? 1 : 1;
            }
        }
    }

    public void drawScreen(int fmx, int fmy, float p) {
        this.drawDefaultBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / this.glScale), (float)(1.0f / this.glScale), (float)(1.0f / this.glScale));
        this.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 142, 180);
        this.drawTexturedModalRect(this.guiLeft + 65, this.guiTop + 167, 142, 147 + this.buttonState * 10, 18, 8);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.display.draw((this.guiLeft + 10 + 1) * 2, (this.guiTop + 8 + 1) * 2, this.zLevel);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glDisable((int)3042);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

