/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.Packet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class PacketTabletMessage
extends Packet {
    private NBTTagCompound tag;

    public PacketTabletMessage() {
        this.tag = new NBTTagCompound();
    }

    public PacketTabletMessage(NBTTagCompound tag) {
        this.tag = tag;
    }

    @Override
    public int getID() {
        return 40;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public void readData(ByteBuf data) {
        int length = data.readUnsignedShort();
        byte[] compressed = new byte[length];
        data.readBytes(compressed);
        try {
            this.tag = CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        try {
            byte[] compressed = CompressedStreamTools.compress((NBTTagCompound)this.tag);
            if (compressed.length > 65535) {
                BCLog.logger.error("NBT data is too large (" + compressed.length + " > 65535)! Please report!");
            }
            data.writeShort(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

