/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.BuildCraftCore;
import buildcraft.api.tablet.TabletBitmap;
import buildcraft.api.tablet.TabletProgram;
import buildcraft.core.tablet.PacketTabletMessage;
import buildcraft.core.tablet.TabletBase;
import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class TabletServer
extends TabletBase {
    protected final EntityPlayer player;

    public TabletServer(EntityPlayer player) {
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick(float time) {
        LinkedList linkedList = this.programs;
        synchronized (linkedList) {
            while (this.programs.size() > 0 && ((TabletProgram)this.programs.getLast()).hasEnded()) {
                this.closeProgram();
            }
            if (this.programs.size() == 0) {
                this.launchProgram("menu");
            }
            super.tick(time);
        }
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    @Override
    public void refreshScreen(TabletBitmap newDisplay) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(NBTTagCompound compound) {
        if (!this.receiveMessageInternal(compound) && compound.hasKey("doRemoveProgram")) {
            LinkedList linkedList = this.programs;
            synchronized (linkedList) {
                this.programs.removeLast();
            }
        }
    }

    @Override
    public void launchProgram(String name) {
        if (this.launchProgramInternal(name)) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.setString("programToLaunch", name);
            BuildCraftCore.instance.sendToPlayer(this.player, new PacketTabletMessage(compound));
        }
    }

    protected void closeProgram() {
        this.programs.removeLast();
        NBTTagCompound compound = new NBTTagCompound();
        compound.setBoolean("doRemoveProgram", true);
        BuildCraftCore.instance.sendToPlayer(this.player, new PacketTabletMessage(compound));
    }

    @Override
    public void sendMessage(NBTTagCompound compound) {
        compound.setBoolean("__program", true);
        BuildCraftCore.instance.sendToPlayer(this.player, new PacketTabletMessage(compound));
    }
}

