/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.PowerMode;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.StringUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineCreative
extends TileEngineBase {
    private PowerMode powerMode = PowerMode.M2;

    @Override
    protected TileEngineBase.EnergyStage computeEnergyStage() {
        return TileEngineBase.EnergyStage.BLUE;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!this.getWorldObj().isRemote) {
            Item equipped;
            Item item = equipped = player.getCurrentEquippedItem() != null ? player.getCurrentEquippedItem().getItem() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.xCoord, this.yCoord, this.zCoord)) {
                this.powerMode = this.powerMode.getNext();
                this.energy = 0;
                if (!(player instanceof FakePlayer)) {
                    if (BuildCraftCore.hidePowerNumbers) {
                        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode.numberless", new Object[]{StringUtils.localize("chat.pipe.power.iron.level." + this.powerMode.maxPower)}));
                    } else {
                        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.pipe.power.iron.mode", new Object[]{this.powerMode.maxPower}));
                    }
                }
                this.sendNetworkUpdate();
                ((IToolWrench)equipped).wrenchUsed(player, this.xCoord, this.yCoord, this.zCoord);
                return true;
            }
        }
        return !player.isSneaking();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powerMode = PowerMode.fromId(data.getByte("mode"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("mode", (byte)this.powerMode.ordinal());
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.powerMode = PowerMode.fromId(stream.readUnsignedByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        stream.writeByte(this.powerMode.ordinal());
    }

    @Override
    public void updateHeat() {
    }

    @Override
    public float getPistonSpeed() {
        return 0.02f * (float)(this.powerMode.ordinal() + 1);
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered) {
            this.addEnergy(this.getIdealOutput());
        }
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getMaxEnergy() {
        return this.getIdealOutput();
    }

    @Override
    public int getIdealOutput() {
        return this.powerMode.maxPower;
    }
}

