/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.lib.utils.StringUtils;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.gui.ContainerEngine;
import buildcraft.energy.gui.GuiEngine;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GuiCombustionEngine
extends GuiEngine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftenergy:textures/gui/combustion_engine_gui.png");

    public GuiCombustionEngine(InventoryPlayer inventoryplayer, TileEngineIron tileEngine) {
        super(new ContainerEngine(inventoryplayer, tileEngine), tileEngine, TEXTURE);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        String title = StringUtils.localize("tile.engineIron.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 96 + 2, 0x404040);
        TileEngineIron engine = (TileEngineIron)this.tile;
        FluidStack stack = null;
        if (engine != null && par2 >= this.guiTop + 19 && par2 < this.guiTop + 19 + 60) {
            if (par1 >= this.guiLeft + 104 && par1 < this.guiLeft + 104 + 16) {
                stack = engine.getFuel();
            } else if (par1 >= this.guiLeft + 122 && par1 < this.guiLeft + 122 + 16) {
                stack = engine.getCoolant();
            }
        }
        if (stack != null && stack.amount > 0) {
            ArrayList<String> fluidTip = new ArrayList<String>();
            fluidTip.add(stack.getLocalizedName());
            this.drawHoveringText(fluidTip, par1 - this.guiLeft, par2 - this.guiTop, this.fontRendererObj);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(f, x, y);
        TileEngineIron engine = (TileEngineIron)this.tile;
        if (engine != null) {
            this.drawFluid(engine.getFuel(), this.guiLeft + 104, this.guiTop + 19, 16, 58, TileEngineIron.MAX_LIQUID);
            this.drawFluid(engine.getCoolant(), this.guiLeft + 122, this.guiTop + 19, 16, 58, TileEngineIron.MAX_LIQUID);
        }
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft + 104, this.guiTop + 19, 176, 0, 16, 60);
        this.drawTexturedModalRect(this.guiLeft + 122, this.guiTop + 19, 176, 0, 16, 60);
    }
}

