/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.factory.TileFloodGate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFloodGate
extends BlockBuildCraft {
    private IIcon valve;
    private IIcon transparent;

    public BlockFloodGate() {
        super(Material.iron);
        this.setPassCount(2);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileFloodGate();
    }

    @Override
    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int side, float par7, float par8, float par9) {
        if (super.onBlockActivated(world, i, j, k, entityplayer, side, par7, par8, par9)) {
            return true;
        }
        if (entityplayer.isSneaking()) {
            return false;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileFloodGate) {
            Item equipped;
            TileFloodGate floodGate = (TileFloodGate)tile;
            Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, i, j, k)) {
                if (side == 1) {
                    floodGate.rebuildQueue();
                } else {
                    floodGate.switchSide(ForgeDirection.getOrientation((int)side));
                }
                ((IToolWrench)equipped).wrenchUsed(entityplayer, i, j, k);
                return true;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileFloodGate) {
            ((TileFloodGate)tile).onNeighborBlockChange(block);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        super.registerBlockIcons(register);
        this.valve = register.registerIcon("buildcraftfactory:floodGateBlock/valve");
        this.transparent = register.registerIcon("buildcraftcore:misc/transparent");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        if (this.renderPass == 1) {
            TileEntity tile;
            if (side != 1 && (tile = world.getTileEntity(x, y, z)) instanceof TileFloodGate) {
                return ((TileFloodGate)tile).isSideBlocked(side) ? this.transparent : this.valve;
            }
            return this.transparent;
        }
        return super.getIcon(world, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        if (this.renderPass == 1) {
            if (side == 1) {
                return null;
            }
            return this.valve;
        }
        return super.getIcon(side, metadata);
    }
}

