/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.fluids.TankUtils;
import buildcraft.factory.TileRefinery;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class BlockRefinery
extends BlockBuildCraft {
    public BlockRefinery() {
        super(Material.iron);
        this.setHardness(5.0f);
        this.setCreativeTab(BCCreativeTab.get("main"));
        this.setRotatable(true);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return BuildCraftCore.blockByEntityModel;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileRefinery();
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item equipped;
        if (super.onBlockActivated(world, x, y, z, player, side, hitX, hitY, hitZ)) {
            return true;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileRefinery)) {
            return false;
        }
        ItemStack current = player.getCurrentEquippedItem();
        Item item = equipped = current != null ? current.getItem() : null;
        if (player.isSneaking() && equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, x, y, z)) {
            ((TileRefinery)tile).resetFilters();
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        if (current != null && current.getItem() != Items.bucket && (!world.isRemote ? TankUtils.handleRightClick((TileRefinery)tile, ForgeDirection.getOrientation((int)side), player, true, false) : FluidContainerRegistry.isContainer((ItemStack)current))) {
            return true;
        }
        if (!world.isRemote) {
            player.openGui((Object)BuildCraftFactory.instance, 31, world, x, y, z);
        }
        return true;
    }
}

